/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.util.List;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.compiler.CompilerProvider;
import org.jamocha.rete.compiler.ConditionCompiler;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.ObjectCondition;

public class TemporalCondition
extends ObjectCondition {
    protected String varname = null;
    protected int relativeTime = 0;
    protected int intervalTime = 0;
    protected String function = null;
    protected Parameter[] parameters = null;

    public String getVariableName() {
        return this.varname;
    }

    public void setVariableName(String name) {
        this.varname = name;
    }

    public void setRelativeTime(int time) {
        this.relativeTime = time;
    }

    public int getRelativeTime() {
        return this.relativeTime;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public int getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(int intervalTime) {
        this.intervalTime = intervalTime;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public void addFunction(List list) {
        if (list.size() > 0) {
            Object[] array = list.toArray();
            ValueParam vp = (ValueParam)array[0];
            this.setFunction(vp.getStringValue());
            Parameter[] params = new Parameter[array.length - 1];
            int idx = 1;
            while (idx < array.length) {
                params[idx - 1] = (Parameter)array[idx];
                ++idx;
            }
            this.setParameters(params);
        }
    }

    public boolean compare(Condition cond) {
        return false;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        int start = 0;
        String pad = "  ";
        buf.append(String.valueOf(pad) + "(temporal" + Constants.LINEBREAK);
        if (this.negated) {
            buf.append(String.valueOf(pad) + pad + "(relative-time " + this.relativeTime + ")" + Constants.LINEBREAK);
        } else {
            buf.append(String.valueOf(pad) + pad + "?" + this.varname + Constants.LINEBREAK);
            buf.append(String.valueOf(pad) + pad + "(relative-time " + this.relativeTime + ")" + Constants.LINEBREAK);
        }
        if (this.negated) {
            buf.append(String.valueOf(pad) + pad + "(not" + Constants.LINEBREAK);
            pad = "      ";
        } else {
            pad = "    ";
        }
        buf.append(String.valueOf(pad) + "(" + this.templateName + Constants.LINEBREAK);
        int idx = start;
        while (idx < this.constraints.size()) {
            Constraint cnstr = (Constraint)this.constraints.get(idx);
            if (this.negated) {
                buf.append("    " + cnstr.toPPString());
            } else {
                buf.append("  " + cnstr.toPPString());
            }
            ++idx;
        }
        if (this.negated) {
            buf.append(String.valueOf(pad) + ")" + Constants.LINEBREAK);
        }
        pad = "  ";
        buf.append(String.valueOf(pad) + pad + ")" + Constants.LINEBREAK);
        buf.append(String.valueOf(pad) + ")" + Constants.LINEBREAK);
        return buf.toString();
    }

    public ConditionCompiler getCompiler(RuleCompiler ruleCompiler) {
        CompilerProvider.getInstance(ruleCompiler);
        return CompilerProvider.temporalConditionCompiler;
    }
}

