/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import org.jamocha.rete.BaseSlot;
import org.jamocha.rete.Function;
import org.jamocha.rete.Messages;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Template;
import org.jamocha.rule.Action;
import org.jamocha.rule.Analysis;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.ErrorSummary;
import org.jamocha.rule.ExistCondition;
import org.jamocha.rule.FunctionAction;
import org.jamocha.rule.LiteralConstraint;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Rule;
import org.jamocha.rule.Summary;
import org.jamocha.rule.TestCondition;
import org.jamocha.rule.WarningSummary;
import org.jamocha.rule.util.GenerateFacts;

public class TemplateValidation
implements Analysis {
    private Rete engine = null;
    private ErrorSummary error = null;
    private WarningSummary warning = null;
    public static final String INVALID_SLOT = Messages.getString("CompilerProperties.invalid.slot");
    public static final String INVALID_TEMPLATE = Messages.getString("CompilerProperties.invalid.template");
    public static final String INVALID_FUNCTION = Messages.getString("CompilerProperties.invalid.function");
    public static final String NO_FUNCTION = Messages.getString("CompilerProperties.no.function");
    public static final String NO_MODULE = Messages.getString("CompilerProperties.no.module");

    public TemplateValidation(Rete engine) {
        this.engine = engine;
    }

    public Summary getErrors() {
        return this.error;
    }

    public void reset() {
        this.error = null;
        this.warning = null;
    }

    public Summary getWarnings() {
        return this.warning;
    }

    public int analyze(Rule rule) {
        int result = 1001;
        this.error = new ErrorSummary();
        this.warning = new WarningSummary();
        this.checkForModule(rule);
        Condition[] cnds = rule.getConditions();
        int idx = 0;
        while (idx < cnds.length) {
            Condition cnd = cnds[idx];
            if (cnd instanceof ObjectCondition) {
                ObjectCondition oc = (ObjectCondition)cnd;
                Template dft = oc.getTemplate();
                if (dft != null) {
                    Constraint[] cntrs = oc.getConstraints();
                    int idy = 0;
                    while (idy < cntrs.length) {
                        PredicateConstraint pc;
                        Function f;
                        Constraint cons = cntrs[idy];
                        if (cons instanceof LiteralConstraint) {
                            BaseSlot sl = dft.getSlot(cons.getName());
                            if (sl == null) {
                                this.error.addMessage(String.valueOf(INVALID_SLOT) + " " + cons.getName() + " slot does not exist.");
                                result = 1000;
                            }
                        } else if (cons instanceof BoundConstraint) {
                            BaseSlot sl;
                            BoundConstraint bc = (BoundConstraint)cons;
                            if (!bc.isObjectBinding && (sl = dft.getSlot(bc.getName())) == null) {
                                this.error.addMessage(String.valueOf(INVALID_SLOT) + " " + cons.getName() + " slot does not exist.");
                                result = 1000;
                            }
                        } else if (cons instanceof PredicateConstraint && (f = this.engine.findFunction((pc = (PredicateConstraint)cons).getFunctionName())) == null) {
                            this.addInvalidFunctionError(pc.getFunctionName());
                        }
                        ++idy;
                    }
                } else {
                    this.error.addMessage(String.valueOf(INVALID_TEMPLATE) + " " + oc.getTemplateName() + " template does not exist.");
                    result = 1000;
                }
            } else if (cnd instanceof TestCondition) {
                TestCondition tc = (TestCondition)cnd;
                if (tc.getFunction() == null) {
                    this.error.addMessage(NO_FUNCTION);
                    result = 1000;
                } else {
                    Function f = tc.getFunction();
                    if (this.engine.findFunction(f.getName()) == null) {
                        this.addInvalidFunctionError(f.getName());
                        result = 1000;
                    }
                }
            } else {
                boolean cfr_ignored_0 = cnd instanceof ExistCondition;
            }
            ++idx;
        }
        Action[] acts = rule.getActions();
        int idx2 = 0;
        while (idx2 < acts.length) {
            FunctionAction fa;
            Action act = acts[idx2];
            if (act instanceof FunctionAction && this.engine.findFunction((fa = (FunctionAction)act).getFunctionName()) == null) {
                this.addInvalidFunctionError(fa.getFunctionName());
                result = 1000;
            }
            ++idx2;
        }
        return result;
    }

    protected void checkForModule(Rule rule) {
        String modname;
        if (rule.getName().indexOf("::") > 0 && this.engine.findModule(modname = GenerateFacts.parseModuleName(rule, this.engine)) == null) {
            this.error.addMessage(NO_MODULE);
        }
    }

    public void addInvalidFunctionError(String name) {
        this.error.addMessage(String.valueOf(INVALID_FUNCTION) + " " + name + " does not exist.");
    }
}

