/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.ValueParam;
import org.jamocha.rule.Constraint;

public class PredicateConstraint
implements Constraint {
    protected String name = null;
    protected String varName = null;
    protected String functionName = null;
    protected Object value = null;
    protected ArrayList parameters = new ArrayList();
    protected boolean isPredicateJoin = false;
    protected boolean reverseOperator = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    public String getVariableName() {
        return this.varName;
    }

    public void setVariableName(String name) {
        this.varName = name;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String func) {
        this.functionName = func;
    }

    public boolean isPredicateJoin() {
        return this.isPredicateJoin;
    }

    public void addParameters(List params) {
        this.parameters.addAll(params);
        int bcount = 0;
        int idx = 0;
        while (idx < this.parameters.size()) {
            FunctionParam2 fparam;
            Object p = this.parameters.get(idx);
            if (p instanceof ValueParam) {
                this.setValue(((ValueParam)p).getValue());
                if (idx == 0) {
                    this.reverseOperator = true;
                }
            } else if (p instanceof BoundParam) {
                BoundParam bp = (BoundParam)p;
                if (!bp.getVariableName().equals(this.varName)) {
                    this.setValue(p);
                }
                ++bcount;
            } else if (p instanceof FunctionParam2 && (fparam = (FunctionParam2)p).hasBoundParameter()) {
                ++bcount;
            }
            ++idx;
        }
        if (bcount > 1) {
            this.isPredicateJoin = true;
        }
    }

    public void addParameter(Parameter param) {
        this.parameters.add(param);
        if (param instanceof ValueParam) {
            this.setValue(((ValueParam)param).getValue());
        } else if (param instanceof BoundParam && this.varName == null) {
            this.varName = ((BoundParam)param).getVariableName();
        }
    }

    public List getParameters() {
        return this.parameters;
    }

    public int parameterCount() {
        return this.parameters.size();
    }

    public boolean reverseOperator() {
        return this.reverseOperator;
    }

    public void normalize() {
    }

    public String toPPString() {
        String function = this.functionName;
        if (this.reverseOperator) {
            function = ConversionUtils.getOppositeOperator(function);
        }
        if (this.value instanceof BoundParam) {
            return "    (" + this.name + " ?" + this.varName + "&:(" + function + " ?" + this.varName + " " + ((BoundParam)this.value).toPPString() + ") )" + Constants.LINEBREAK;
        }
        if (this.value != null) {
            return "    (" + this.name + " ?" + this.varName + "&:(" + function + " ?" + this.varName + " " + this.value.toString() + ") )" + Constants.LINEBREAK;
        }
        StringBuffer buf = new StringBuffer();
        if (this.parameters != null & this.parameters.size() > 0) {
            buf.append("    (" + this.name + " ?" + this.varName + "&:(" + function + " ");
            int idx = 0;
            while (idx < this.parameters.size()) {
                Parameter p = (Parameter)this.parameters.get(idx);
                if (p instanceof FunctionParam2) {
                    buf.append(((FunctionParam2)p).toPPString());
                }
                ++idx;
            }
            buf.append(" ) )" + Constants.LINEBREAK);
        }
        return buf.toString();
    }
}

