/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jamocha.rete.Constants;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.MultiValue;

public class OrLiteralConstraint
implements Constraint {
    protected String name;
    protected ArrayList value = new ArrayList();
    protected boolean negated = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        if (val instanceof ArrayList) {
            this.value = (ArrayList)val;
        }
    }

    public void addValue(MultiValue mv) {
        this.value.add(mv);
    }

    public void addValues(Collection list) {
        this.value.addAll(list);
    }

    public void setNegated(boolean negate) {
        this.negated = negate;
    }

    public boolean getNegated() {
        return this.negated;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        Iterator itr = this.value.iterator();
        buf.append("    (" + this.name + " ");
        int count = 0;
        while (itr.hasNext()) {
            MultiValue mv = (MultiValue)itr.next();
            if (count > 0) {
                buf.append("|");
            }
            if (mv.getNegated()) {
                buf.append("~" + ConversionUtils.formatSlot(mv.getValue()));
            } else {
                buf.append(ConversionUtils.formatSlot(mv.getValue()));
            }
            ++count;
        }
        buf.append(")" + Constants.LINEBREAK);
        return buf.toString();
    }
}

