/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import org.jamocha.rete.Constants;
import org.jamocha.rete.QueryCompiler;
import org.jamocha.rete.RuleCompiler;
import org.jamocha.rete.compiler.CompilerProvider;
import org.jamocha.rete.compiler.ConditionCompiler;
import org.jamocha.rule.AbstractCondition;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;

public class ObjectCondition
extends AbstractCondition {
    private boolean hasNotEqual = false;
    private boolean hasPredicateJoin = false;

    public boolean compare(Condition cond) {
        return false;
    }

    public String toPPString() {
        BoundConstraint bc;
        StringBuffer buf = new StringBuffer();
        int start = 0;
        String pad = "  ";
        boolean obind = false;
        Constraint cn = (Constraint)this.constraints.get(0);
        if (cn instanceof BoundConstraint && (bc = (BoundConstraint)cn).getIsObjectBinding()) {
            start = 1;
            buf.append(bc.toFactBindingPPString());
            pad = " ";
            obind = true;
        }
        if (this.negated) {
            buf.append(String.valueOf(pad) + "(not" + Constants.LINEBREAK);
            pad = "    ";
        }
        buf.append(String.valueOf(pad) + "(" + this.templateName + Constants.LINEBREAK);
        int idx = start;
        while (idx < this.constraints.size()) {
            Constraint cnstr = (Constraint)this.constraints.get(idx);
            if (this.negated) {
                buf.append("  " + cnstr.toPPString());
            } else {
                buf.append(cnstr.toPPString());
            }
            ++idx;
        }
        if (this.negated) {
            buf.append(String.valueOf(pad) + ")" + Constants.LINEBREAK);
            pad = "  ";
        }
        if (obind && !this.negated) {
            buf.append(String.valueOf(pad) + " )" + Constants.LINEBREAK);
        } else {
            buf.append(String.valueOf(pad) + ")" + Constants.LINEBREAK);
        }
        return buf.toString();
    }

    public String toPPString(int tabs) {
        BoundConstraint bc;
        StringBuffer buf = new StringBuffer();
        int tabCount = tabs;
        int start = 0;
        boolean obind = false;
        Constraint cn = (Constraint)this.constraints.get(0);
        if (cn instanceof BoundConstraint && (bc = (BoundConstraint)cn).getIsObjectBinding()) {
            start = 1;
            buf.append(bc.toFactBindingPPString());
            obind = true;
        }
        if (this.negated) {
            buf.append(String.valueOf(this.padding(tabCount)) + "(not" + Constants.LINEBREAK);
            ++tabCount;
        }
        buf.append(String.valueOf(this.padding(tabCount)) + "(" + this.templateName + Constants.LINEBREAK);
        int idx = start;
        while (idx < this.constraints.size()) {
            Constraint cnstr = (Constraint)this.constraints.get(idx);
            if (this.negated) {
                buf.append(String.valueOf(this.padding(tabCount)) + cnstr.toPPString());
            } else {
                buf.append(String.valueOf(this.padding(tabCount - 1)) + cnstr.toPPString());
            }
            ++idx;
        }
        if (this.negated) {
            buf.append(String.valueOf(this.padding(tabCount)) + ")" + Constants.LINEBREAK);
        }
        if (obind && !this.negated) {
            buf.append(String.valueOf(this.padding(tabCount + 1)) + ")" + Constants.LINEBREAK);
        } else {
            buf.append(String.valueOf(this.padding(tabCount)) + ")" + Constants.LINEBREAK);
        }
        return buf.toString();
    }

    protected String padding(int count) {
        String pad = "";
        int idx = 0;
        while (idx < count) {
            pad = String.valueOf(pad) + "  ";
            ++idx;
        }
        return pad;
    }

    public ConditionCompiler getCompiler(RuleCompiler ruleCompiler) {
        CompilerProvider.getInstance(ruleCompiler);
        return CompilerProvider.objectConditionCompiler;
    }

    public ConditionCompiler getCompiler(QueryCompiler ruleCompiler) {
        CompilerProvider.getInstance(ruleCompiler);
        return CompilerProvider.objectConditionCompiler;
    }

    public boolean isHasNotEqual() {
        return this.hasNotEqual;
    }

    public void setHasNotEqual(boolean hasNotEqual) {
        this.hasNotEqual = hasNotEqual;
    }

    public boolean isHasPredicateJoin() {
        return this.hasPredicateJoin;
    }

    public void setHasPredicateJoin(boolean hasPredicateJoin) {
        this.hasPredicateJoin = hasPredicateJoin;
    }
}

