/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Deffact;
import org.jamocha.rete.Deftemplate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.RuleFunction;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.exception.ExecuteException;
import org.jamocha.rete.functions.AssertFunction;
import org.jamocha.rete.functions.ShellFunction;
import org.jamocha.rule.Action;
import org.jamocha.rule.Rule;

public class FunctionAction
implements Action {
    protected Function faction = null;
    protected String functionName = null;
    protected Parameter[] parameters = null;

    public Function getFunction() {
        return this.faction;
    }

    public void setFunction(Function func) {
        if (func instanceof ShellFunction) {
            ShellFunction sf = (ShellFunction)func;
            this.functionName = sf.getName();
            this.parameters = sf.getParameters();
        } else {
            this.faction = func;
            this.functionName = func.getName();
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] params) {
        this.parameters = params;
    }

    public void configure(Rete engine, Rule util) {
        if (this.functionName != null && engine.findFunction(this.functionName) != null) {
            this.faction = engine.findFunction(this.functionName);
        }
        int idx = 0;
        while (idx < this.parameters.length) {
            ValueParam vp;
            if (this.parameters[idx] instanceof BoundParam) {
                BoundParam bp = (BoundParam)this.parameters[idx];
                Binding bd = util.getBinding(bp.getVariableName());
                if (bd != null) {
                    bp.setRow(bd.getLeftRow());
                    bp.setColumn(bd.getLeftIndex());
                }
            } else if (this.parameters[idx] instanceof FunctionParam2) {
                FunctionParam2 fp2 = (FunctionParam2)this.parameters[idx];
                fp2.configure(engine, util);
            } else if (this.parameters[idx] instanceof ValueParam && (vp = (ValueParam)this.parameters[idx]).getValue() instanceof Deffact) {
                ((Deffact)vp.getValue()).compileBinding(util);
            }
            ++idx;
        }
        if (this.faction instanceof AssertFunction) {
            Deftemplate tmpl = (Deftemplate)engine.getCurrentFocus().getTemplate(this.parameters[0].getStringValue());
            Deffact fact = (Deffact)tmpl.createFact((Object[])this.parameters[1].getValue(), -1L);
            fact.compileBinding(util);
            this.parameters = new ValueParam[1];
            this.parameters[0] = new ValueParam(9, fact);
        }
    }

    public void executeAction(Rete engine, Fact[] facts) throws ExecuteException {
        int idx = 0;
        while (idx < this.parameters.length) {
            if (this.parameters[idx] instanceof BoundParam) {
                ((BoundParam)this.parameters[idx]).setFact(facts);
            } else if (this.parameters[idx] instanceof FunctionParam) {
                ((FunctionParam)this.parameters[idx]).setFacts(facts);
            } else if (this.parameters[idx] instanceof FunctionParam2) {
                ((FunctionParam2)this.parameters[idx]).setEngine(engine);
            }
            ++idx;
        }
        if (this.faction instanceof RuleFunction) {
            ((RuleFunction)this.faction).setTriggerFacts(facts);
        }
        this.faction.executeFunction(engine, this.parameters);
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("  " + this.faction.toPPString(this.parameters, 1) + Constants.LINEBREAK);
        return buf.toString();
    }
}

