/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Module;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Scope;
import org.jamocha.rete.Template;
import org.jamocha.rule.Action;
import org.jamocha.rule.AndCondition;
import org.jamocha.rule.Complexity;
import org.jamocha.rule.ComplexityFactory;
import org.jamocha.rule.Condition;
import org.jamocha.rule.ExistCondition;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.Rule;
import org.jamocha.rule.RuleProperty;
import org.jamocha.rule.TemporalCondition;
import org.jamocha.rule.TestCondition;

public class Defrule
implements Rule,
Scope,
Serializable {
    protected String name = null;
    protected ArrayList conditions = null;
    protected ArrayList actions = null;
    protected ArrayList modificationActions = null;
    protected ArrayList joins = null;
    protected int salience = 100;
    protected boolean auto = false;
    protected Complexity complex = null;
    protected boolean rememberMatch = true;
    protected boolean hashedMemory = true;
    protected boolean noAgenda = false;
    protected String version = "";
    protected Module themodule = null;
    protected Map bindValues = new HashMap();
    private LinkedHashMap bindings = new LinkedHashMap();
    private String comment = "";
    private boolean active = true;
    protected int direction = 10000;
    protected boolean watch = false;
    protected long effectiveDate = 0L;
    protected long expirationDate = 0L;
    protected boolean temporalActivation = false;
    protected int costValue = 0;
    protected Fact[] triggerFacts = null;

    public Defrule() {
        this.complex = ComplexityFactory.newInstance();
        this.complex.setRule(this);
        this.conditions = new ArrayList();
        this.actions = new ArrayList();
        this.joins = new ArrayList();
        this.modificationActions = new ArrayList();
    }

    public Defrule(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean getWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public boolean getAutoFocus() {
        return this.auto;
    }

    public void setAutoFocus(boolean auto) {
        this.auto = auto;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int sal) {
        this.salience = sal;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String text) {
        this.comment = text.substring(1, text.length() - 1);
    }

    public Complexity getComplexity() {
        return this.complex;
    }

    public void setComplexity(Complexity complexity) {
        this.complex = complexity;
    }

    public long getEffectiveDate() {
        return this.effectiveDate;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public void setEffectiveDate(long mstime) {
        this.effectiveDate = mstime;
    }

    public void setExpirationDate(long mstime) {
        this.expirationDate = mstime;
    }

    public boolean getNoAgenda() {
        return this.noAgenda;
    }

    public void setNoAgenda(boolean agenda) {
        this.noAgenda = agenda;
    }

    public boolean getRememberMatch() {
        return this.rememberMatch;
    }

    public void setRememberMatch(boolean remember) {
        this.rememberMatch = remember;
    }

    public boolean getHashedMemory() {
        return this.hashedMemory;
    }

    public void setHashedMemory(boolean hashedMemory) {
        this.hashedMemory = hashedMemory;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String ver) {
        if (ver != null) {
            this.version = ver;
        }
    }

    public int getCostValue() {
        return this.costValue;
    }

    public void setCostValue(int costValue) {
        this.costValue = costValue;
    }

    public void addCondition(Condition cond) {
        this.conditions.add(cond);
    }

    public void addAction(Action act) {
        this.actions.add(act);
    }

    public Condition[] getConditions() {
        Condition[] cond = new Condition[this.conditions.size()];
        this.conditions.toArray(cond);
        return cond;
    }

    public Action[] getActions() {
        Action[] acts = new Action[this.actions.size()];
        this.actions.toArray(acts);
        return acts;
    }

    public Action[] getModificationActions() {
        Action[] acts = new Action[this.modificationActions.size()];
        this.modificationActions.toArray(acts);
        return acts;
    }

    public void addModificationAction(Action act) {
        this.modificationActions.add(act);
    }

    public void setModule(Module mod) {
        this.themodule = mod;
    }

    public Module getModule() {
        return this.themodule;
    }

    public void addJoinNode(BaseJoin node) {
        this.joins.add(node);
    }

    public List getJoins() {
        return this.joins;
    }

    public BaseNode getLastNode() {
        if (this.joins.size() > 0) {
            return (BaseNode)this.joins.get(this.joins.size() - 1);
        }
        if (this.conditions.size() > 0) {
            Condition c = (Condition)this.conditions.get(0);
            if (c instanceof ObjectCondition) {
                return ((ObjectCondition)c).getLastNode();
            }
            if (c instanceof TestCondition) {
                return ((TestCondition)c).getTestNode();
            }
            return null;
        }
        return null;
    }

    public void setBindingValue(Object key, Object value) {
        this.bindValues.put(key, value);
    }

    public Object getBindingValue(Object key) {
        Binding bd;
        Object val = this.bindValues.get(key);
        if (val == null && (bd = (Binding)this.bindings.get(key)) != null) {
            Fact left = this.triggerFacts[bd.getLeftRow()];
            val = bd.getIsObjectVar() ? left : left.getSlotValue(bd.getLeftIndex());
        }
        return val;
    }

    public void setBindingValue(String name, Object value) {
        this.bindValues.put(name, value);
    }

    public void setTriggerFacts(Fact[] facts) {
        this.triggerFacts = facts;
    }

    public void resetTriggerFacts() {
        this.triggerFacts = null;
    }

    public Fact[] getTriggerFacts() {
        return this.triggerFacts;
    }

    public void addBinding(String key, Binding bind) {
        if (!this.bindings.containsKey(key)) {
            this.bindings.put(key, bind);
        }
    }

    public Binding getBinding(String varName) {
        return (Binding)this.bindings.get(varName);
    }

    public Binding copyBinding(String varName) {
        Binding b = this.getBinding(varName);
        if (b != null) {
            Binding b2 = (Binding)b.clone();
            return b2;
        }
        return null;
    }

    public Binding copyPredicateBinding(String varName, int operator) {
        Object value = this.bindings.get(varName);
        if (value != null) {
            if (value instanceof Binding2) {
                Binding2 b = (Binding2)value;
                Binding2 b2 = new Binding2(operator);
                b2.setLeftRow(b.getLeftRow());
                b2.setLeftIndex(b.getLeftIndex());
                b2.setVarName(b.getVarName());
                b2.setQueryValue(b.getQueryValue());
                b2.setRightIndex(b.getRightIndex());
                return b2;
            }
            Binding b = (Binding)value;
            Binding2 b2 = new Binding2(operator);
            b2.setLeftRow(b.getLeftRow());
            b2.setLeftIndex(b.getLeftIndex());
            b2.setVarName(b.getVarName());
            b2.setRightIndex(b.getRightIndex());
            return b2;
        }
        return null;
    }

    public Iterator getBindingIterator() {
        return this.bindings.values().iterator();
    }

    public int getBindingCount() {
        return this.bindings.size();
    }

    public void resolveTemplates(Rete engine) {
        this.resolveConditionTemplates(engine, this.getConditions());
    }

    private void resolveConditionTemplates(Rete engine, Condition[] cnds) {
        int idx = 0;
        while (idx < cnds.length) {
            Template dft;
            Condition cnd = cnds[idx];
            if (cnd instanceof ObjectCondition) {
                ObjectCondition oc = (ObjectCondition)cnd;
                dft = engine.findTemplate(oc.getTemplateName());
                if (dft != null) {
                    oc.setTemplate(dft);
                }
            } else if (cnd instanceof ExistCondition) {
                ExistCondition exc = (ExistCondition)cnd;
                dft = engine.findTemplate(exc.getTemplateName());
                if (dft != null) {
                    exc.setTemplate(dft);
                }
            } else if (cnd instanceof TemporalCondition) {
                TemporalCondition tempc = (TemporalCondition)cnd;
                dft = engine.findTemplate(tempc.getTemplateName());
                if (dft != null) {
                    tempc.setTemplate(dft);
                }
            } else if (cnd instanceof AndCondition) {
                this.resolveConditionTemplates(engine, ((AndCondition)cnd).getConditions());
            }
            ++idx;
        }
    }

    public void setRuleProperties(List props) {
        for (RuleProperty declaration : props) {
            if (declaration.getName().equals("auto-focus")) {
                this.setAutoFocus(declaration.getBooleanValue());
                continue;
            }
            if (declaration.getName().equals("salience")) {
                this.setSalience(declaration.getIntValue());
                continue;
            }
            if (declaration.getName().equals("rule-version")) {
                this.setVersion(declaration.getValue());
                continue;
            }
            if (declaration.getName().equals("remember-alpha")) {
                this.setRememberMatch(declaration.getBooleanValue());
                continue;
            }
            if (declaration.getName().equals("no-agenda")) {
                this.setNoAgenda(declaration.getBooleanValue());
                continue;
            }
            if (declaration.getName().equals("effective-date")) {
                this.effectiveDate = Defrule.getDateTime(declaration.getValue());
                continue;
            }
            if (declaration.getName().equals("expiration-date")) {
                this.expirationDate = Defrule.getDateTime(declaration.getValue());
                continue;
            }
            if (declaration.getName().equals("temporal-activation")) {
                this.temporalActivation = declaration.getBooleanValue();
                continue;
            }
            if (!declaration.getName().equals("hashed-memory")) continue;
            this.hashedMemory = declaration.getBooleanValue();
        }
    }

    public static long getDateTime(String date) {
        if (date != null && date.length() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("mm/dd/yyyy HH:mm");
                return df.parse(date).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0L;
            }
        }
        return 0L;
    }

    public String toPPString() {
        Action ac;
        StringBuffer buf = new StringBuffer();
        buf.append("(defrule " + this.name + Constants.LINEBREAK);
        buf.append("  (declare (salience " + this.salience + ") (rule-version " + this.version + ") (remember-match " + this.rememberMatch + ") (effective-date " + this.effectiveDate + ") (expiration-date " + this.expirationDate + ") (temporal-activation " + this.temporalActivation + ") (no-agenda " + this.noAgenda + ") (chaining-direction " + this.direction + ") )" + Constants.LINEBREAK);
        int idx = 0;
        while (idx < this.conditions.size()) {
            Condition c = (Condition)this.conditions.get(idx);
            buf.append(c.toPPString());
            ++idx;
        }
        buf.append("=>" + Constants.LINEBREAK);
        idx = 0;
        while (idx < this.actions.size()) {
            ac = (Action)this.actions.get(idx);
            buf.append(ac.toPPString());
            ++idx;
        }
        if (this.modificationActions.size() > 0) {
            buf.append("<<=" + Constants.LINEBREAK);
            idx = 0;
            while (idx < this.modificationActions.size()) {
                ac = (Action)this.modificationActions.get(idx);
                buf.append(ac.toPPString());
                ++idx;
            }
        }
        buf.append(")" + Constants.LINEBREAK);
        buf.append(";; topology-cost: " + this.costValue + Constants.LINEBREAK);
        return buf.toString();
    }

    public void clear() {
        for (Condition cond : this.conditions) {
            cond.clear();
        }
        this.joins.clear();
    }

    public Object clone() {
        Defrule cl = new Defrule(this.name);
        return cl;
    }

    public boolean isTemporalActivation() {
        return this.temporalActivation;
    }

    public void setTemporalActivation(boolean temporalActivation) {
        this.temporalActivation = temporalActivation;
    }
}

