/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Template;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlphaCondition;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryBaseNot;
import org.jamocha.rete.query.QueryFuncAlphaNode;
import org.jamocha.rete.query.QueryParameterNode;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rete.query.QueryRootNode;
import org.jamocha.rule.AndCondition;
import org.jamocha.rule.Condition;
import org.jamocha.rule.ExistCondition;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.Query;
import org.jamocha.rule.TemporalCondition;
import org.jamocha.rule.TestCondition;

public class Defquery
implements Query,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected ArrayList conditions = null;
    protected ArrayList joins = null;
    protected ArrayList notJoins = null;
    protected Map variables = new HashMap();
    protected boolean auto = false;
    protected String version = "";
    protected Map bindValues = new HashMap();
    private LinkedHashMap bindings = new LinkedHashMap();
    private String comment = "";
    private QueryRootNode queryRoot = null;
    private QueryResultNode resultNode = null;
    private Map queryParameterNodeMap = new LinkedHashMap();
    protected boolean watch = false;
    protected long elapsedTime = 0L;
    protected long startTime = 0L;

    public Defquery() {
        this.conditions = new ArrayList();
        this.joins = new ArrayList();
        this.notJoins = new ArrayList();
    }

    public Defquery(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getWatch() {
        return this.watch;
    }

    public void setWatch(boolean watch) {
        this.watch = watch;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String text) {
        this.comment = text.substring(1, text.length() - 1);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String ver) {
        if (ver != null) {
            this.version = ver;
        }
    }

    public void addCondition(Condition cond) {
        this.conditions.add(cond);
    }

    public Condition[] getConditions() {
        Condition[] cond = new Condition[this.conditions.size()];
        this.conditions.toArray(cond);
        return cond;
    }

    public void addJoinNode(QueryBaseJoin node) {
        this.joins.add(node);
    }

    public List getJoins() {
        return this.joins;
    }

    public void addNotNode(QueryBaseNot node) {
        this.notJoins.add(node);
    }

    public List getNotNodes() {
        return this.notJoins;
    }

    public BaseNode getLastNode() {
        if (this.joins.size() > 0) {
            return (BaseNode)this.joins.get(this.joins.size() - 1);
        }
        if (this.conditions.size() > 0) {
            Condition c = (Condition)this.conditions.get(0);
            if (c instanceof ObjectCondition) {
                return ((ObjectCondition)c).getLastNode();
            }
            if (c instanceof TestCondition) {
                return ((TestCondition)c).getTestNode();
            }
            return null;
        }
        return null;
    }

    public void addBinding(String key, Binding bind) {
        if (!this.bindings.containsKey(key)) {
            this.bindings.put(key, bind);
        }
    }

    public Binding getBinding(String varName) {
        return (Binding)this.bindings.get(varName);
    }

    public Binding copyBinding(String varName) {
        Binding b = this.getBinding(varName);
        if (b != null) {
            Binding b2 = (Binding)b.clone();
            return b2;
        }
        return null;
    }

    public Binding copyPredicateBinding(String varName, int operator) {
        Binding2 b = (Binding2)this.getBinding(varName);
        if (b != null) {
            Binding2 b2 = new Binding2(operator);
            b2.setLeftRow(b.getLeftRow());
            b2.setLeftIndex(b.getLeftIndex());
            b2.setVarName(b.getVarName());
            b2.setQueryValue(b.getQueryValue());
            b2.setRightIndex(b.getRightIndex());
            return b2;
        }
        return null;
    }

    public Iterator getBindingIterator() {
        return this.bindings.values().iterator();
    }

    public int getBindingCount() {
        return this.bindings.size();
    }

    public void addQueryParameterNode(QueryParameterNode parameterNode) {
        if (this.queryParameterNodeMap.containsKey(parameterNode.getParameterName())) {
            this.queryParameterNodeMap.put(parameterNode.getParameterName(), parameterNode);
        }
    }

    public void addQueryFuncNode(QueryFuncAlphaNode funcNode) {
        if (this.queryParameterNodeMap.containsKey(funcNode.getParameterName())) {
            this.queryParameterNodeMap.put(funcNode.getParameterName(), funcNode);
        }
    }

    public void resolveTemplates(Rete engine) {
        this.resolveConditionTemplates(engine, this.getConditions());
    }

    private void resolveConditionTemplates(Rete engine, Condition[] cnds) {
        int idx = 0;
        while (idx < cnds.length) {
            Template dft;
            Condition cnd = cnds[idx];
            if (cnd instanceof ObjectCondition) {
                ObjectCondition oc = (ObjectCondition)cnd;
                dft = engine.findTemplate(oc.getTemplateName());
                if (dft != null) {
                    oc.setTemplate(dft);
                }
            } else if (cnd instanceof ExistCondition) {
                ExistCondition exc = (ExistCondition)cnd;
                dft = engine.findTemplate(exc.getTemplateName());
                if (dft != null) {
                    exc.setTemplate(dft);
                }
            } else if (cnd instanceof TemporalCondition) {
                TemporalCondition tempc = (TemporalCondition)cnd;
                dft = engine.findTemplate(tempc.getTemplateName());
                if (dft != null) {
                    tempc.setTemplate(dft);
                }
            } else if (cnd instanceof AndCondition) {
                this.resolveConditionTemplates(engine, ((AndCondition)cnd).getConditions());
            }
            ++idx;
        }
    }

    public void setQueryParameters(List props) {
        for (String var : props) {
            if (!var.startsWith("?")) continue;
            String variable = var.substring(1);
            this.variables.put(variable, variable);
            this.queryParameterNodeMap.put(variable, null);
        }
    }

    private void setQueryParameters(Map variables) {
        for (String variable : variables.keySet()) {
            this.variables.put(variable, variable);
            this.queryParameterNodeMap.put(variable, null);
        }
    }

    public boolean isQueryParameter(String name) {
        return this.variables.containsKey(name);
    }

    public static long getDateTime(String date) {
        if (date != null && date.length() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("mm/dd/yyyy HH:mm");
                return df.parse(date).getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0L;
            }
        }
        return 0L;
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        return buf.toString();
    }

    public void clear() {
        for (Condition cond : this.conditions) {
            cond.clear();
        }
        this.joins.clear();
    }

    public Defquery clone(Rete engine) {
        Defquery clone = new Defquery(this.name);
        clone.setQueryParameters(this.queryParameterNodeMap);
        clone.bindings = this.bindings;
        clone.comment = this.comment;
        clone.conditions = this.conditions;
        clone.name = this.name;
        clone.watch = this.watch;
        clone.queryRoot = this.queryRoot.clone(engine, clone);
        return clone;
    }

    public void setQueryNetwork(QueryRootNode queryRoot) {
        this.queryRoot = queryRoot;
    }

    public QueryRootNode getQueryRootNode() {
        return this.queryRoot;
    }

    public void setQueryResultNode(QueryResultNode queryResultNode) {
        this.resultNode = queryResultNode;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long time) {
        this.elapsedTime = time;
    }

    public List executeQuery(Rete engine, WorkingMemory memory, Parameter[] parameters) {
        if (this.watch) {
            this.startTime = System.currentTimeMillis();
        }
        try {
            ArrayList params = new ArrayList(this.queryParameterNodeMap.values());
            int i = 0;
            while (i < parameters.length) {
                QueryBaseAlphaCondition pnode;
                Object node = params.get(i);
                if (node instanceof QueryParameterNode) {
                    pnode = (QueryParameterNode)node;
                    ((QueryParameterNode)pnode).setQueryParameterValue(parameters[i].getValue());
                } else if (node instanceof QueryFuncAlphaNode) {
                    pnode = (QueryFuncAlphaNode)node;
                    ((QueryFuncAlphaNode)pnode).setQueryParameterValue(parameters[i].getValue());
                }
                ++i;
            }
            this.queryRoot.assertObject(null, engine, memory);
            i = 0;
            while (i < this.notJoins.size()) {
                ((QueryBaseNot)this.notJoins.get(i)).executeJoin(engine, memory);
                ++i;
            }
        }
        catch (AssertException assertException) {
            // empty catch block
        }
        if (this.watch) {
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            engine.setQueryTime(this.name, this.elapsedTime);
        }
        return this.resultNode.getResults();
    }
}

