/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import org.jamocha.rule.AndLiteralConstraint;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Complexity;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.ExistCondition;
import org.jamocha.rule.ObjectCondition;
import org.jamocha.rule.OrLiteralConstraint;
import org.jamocha.rule.PredicateConstraint;
import org.jamocha.rule.Rule;
import org.jamocha.rule.TestCondition;

public class DefaultComplexity
implements Complexity {
    private Rule rule = null;
    private int complexityValue = 0;

    public void setRule(Rule r) {
        this.rule = r;
    }

    public int getValue() {
        return this.complexityValue;
    }

    public void calculateComplexity() {
        if (this.rule != null) {
            Condition[] conditions = this.rule.getConditions();
            int idx = 0;
            while (idx < conditions.length) {
                ++this.complexityValue;
                Condition cond = conditions[idx];
                if (cond instanceof ObjectCondition) {
                    ObjectCondition oc = (ObjectCondition)cond;
                    Constraint[] constraints = oc.getConstraints();
                    int bindingCount = 0;
                    int idc = 0;
                    while (idc < constraints.length) {
                        int count = 0;
                        if (constraints[idc] instanceof AndLiteralConstraint || constraints[idc] instanceof OrLiteralConstraint || constraints[idc] instanceof PredicateConstraint) {
                            ++count;
                        }
                        if (constraints[idc] instanceof BoundConstraint) {
                            ++count;
                        }
                        this.complexityValue = ++count + bindingCount + this.complexityValue;
                        ++idc;
                    }
                    if (oc.negated || oc instanceof ExistCondition) {
                        this.complexityValue += 2;
                    }
                } else if (cond instanceof TestCondition) {
                    this.complexityValue += 2;
                }
                ++idx;
            }
        }
    }
}

