/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.Constants;
import org.jamocha.rule.Constraint;

public class BoundConstraint
implements Constraint {
    protected String name;
    protected Object value;
    protected boolean isObjectBinding = false;
    protected boolean negated = false;
    protected boolean firstDeclaration = false;
    protected boolean isMultislot = false;
    protected boolean intraFactJoin = false;
    protected List ifjoins = new ArrayList();

    public BoundConstraint() {
    }

    public BoundConstraint(String name, boolean isObjBind) {
        this.setName(name);
        this.isObjectBinding = isObjBind;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.startsWith("?") ? name.substring(1) : name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    public String getVariableName() {
        return (String)this.value;
    }

    public void setIsObjectBinding(boolean obj) {
        this.isObjectBinding = obj;
    }

    public boolean getIsObjectBinding() {
        return this.isObjectBinding;
    }

    public boolean isMultislot() {
        return this.isMultislot;
    }

    public void setIsMultislot(boolean multi) {
        this.isMultislot = multi;
    }

    public void setNegated(boolean negate) {
        this.negated = negate;
    }

    public boolean getNegated() {
        return this.negated;
    }

    public void setFirstDeclaration(boolean first) {
        this.firstDeclaration = first;
    }

    public boolean firstDeclaration() {
        return this.firstDeclaration;
    }

    public boolean hasIntraFactJoin() {
        return this.intraFactJoin;
    }

    public void setIntraFactJoin(boolean intraFactJoin) {
        this.intraFactJoin = intraFactJoin;
    }

    public void addIntrFactJoin(List list) {
        if (list.size() > 0) {
            for (BoundConstraint bc : list) {
                bc.setName(this.name);
                this.ifjoins.add(bc);
            }
        }
    }

    public BoundConstraint getFirstIFJ() {
        return (BoundConstraint)this.ifjoins.get(0);
    }

    public String toPPString() {
        if (this.isMultislot) {
            return "    (" + this.name + " $?" + this.value.toString() + ")" + Constants.LINEBREAK;
        }
        if (this.negated) {
            return "    (" + this.name + " ~?" + this.value.toString() + ")" + Constants.LINEBREAK;
        }
        return "    (" + this.name + " ?" + this.value.toString() + ")" + Constants.LINEBREAK;
    }

    public String toFactBindingPPString() {
        return "  ?" + this.value.toString() + " <-";
    }
}

