/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rule;

import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Template;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rule.BoundConstraint;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Constraint;
import org.jamocha.rule.PredicateConstraint;

public abstract class AbstractCondition
implements Condition {
    private static final long serialVersionUID = 1L;
    protected String templateName = null;
    protected List constraints = new ArrayList(8);
    protected boolean negated = false;
    protected List nodes = new ArrayList();
    protected Template template = null;
    protected long partialMatchCount = 0L;

    public void addNewAlphaNodes(BaseNode node) {
        if (node != null) {
            if (!this.nodes.contains(node)) {
                this.nodes.add(node);
            }
            int i = 0;
            while (i < node.getSuccessorNodes().length) {
                this.nodes.add(node.getSuccessorNodes()[i]);
                if (node instanceof BaseAlpha) {
                    this.addNewAlphaNodes((BaseAlpha)node.getSuccessorNodes()[i]);
                } else if (node instanceof QueryBaseAlpha) {
                    this.addNewAlphaNodes((QueryBaseAlpha)node.getSuccessorNodes()[i]);
                }
                ++i;
            }
        }
    }

    public void addNode(BaseNode node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
        }
    }

    public void clear() {
        this.nodes.clear();
    }

    public abstract boolean compare(Condition var1);

    public List getBindConstraints() {
        ArrayList binds = new ArrayList();
        for (Object c : this.constraints) {
            PredicateConstraint pc;
            if (c instanceof BoundConstraint) {
                BoundConstraint bc = (BoundConstraint)c;
                if (bc.firstDeclaration() || bc.getIsObjectBinding()) continue;
                binds.add(c);
                continue;
            }
            if (!(c instanceof PredicateConstraint) || !(pc = (PredicateConstraint)c).isPredicateJoin()) continue;
            binds.add(pc);
        }
        return binds;
    }

    public BaseNode getFirstNode() {
        if (this.nodes.size() > 0) {
            return (BaseNode)this.nodes.get(0);
        }
        return null;
    }

    public BaseNode getLastNode() {
        if (this.nodes.size() > 0) {
            return (BaseNode)this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    public List getNodes() {
        return this.nodes;
    }

    public abstract String toPPString();

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String name) {
        this.templateName = name;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template tmpl) {
        this.template = tmpl;
    }

    public void setNegated(boolean negate) {
        this.negated = negate;
    }

    public boolean getNegated() {
        return this.negated;
    }

    public Constraint[] getConstraints() {
        Constraint[] con = new Constraint[this.constraints.size()];
        return this.constraints.toArray(con);
    }

    public void addConstraint(Constraint con) {
        this.constraints.add(con);
    }

    public void addConstraint(Constraint con, int position) {
        this.constraints.add(0, con);
    }

    public void removeConstraint(Constraint con) {
        this.constraints.remove(con);
    }

    public void setPartialMatchCount(long matchCount) {
        this.partialMatchCount = matchCount;
    }

    public long getPartialMatchCount() {
        return this.partialMatchCount;
    }
}

