/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jamocha.gui.icons.IconLoader;
import org.jamocha.rete.AlphaNodePredConstr;
import org.jamocha.rete.BaseAlpha2;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.EngineEvent;
import org.jamocha.rete.EngineEventListener;
import org.jamocha.rete.LIANode;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Rete;
import org.jamocha.rete.RootNode;
import org.jamocha.rete.TerminalNode;
import org.jamocha.rete.visualisation.ConnectorLine;
import org.jamocha.rete.visualisation.Ellipse;
import org.jamocha.rete.visualisation.JMiniRadarShapeContainer;
import org.jamocha.rete.visualisation.JZoomableShapeContainer;
import org.jamocha.rete.visualisation.Rectangle;
import org.jamocha.rete.visualisation.RoundedRectangle;
import org.jamocha.rete.visualisation.Shape;
import org.jamocha.rete.visualisation.Trapezoid;
import org.jamocha.rete.visualisation.ViewGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visualiser
implements ActionListener,
MouseListener,
EngineEventListener {
    protected JZoomableShapeContainer container;
    protected JMiniRadarShapeContainer radar;
    protected ViewGraphNode root;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected JButton reloadButton;
    protected JScrollPane scrollPane;
    protected JToggleButton autoReloadButton;
    protected JTextPane dump;
    protected JFrame myFrame;
    protected Rete engine;
    protected boolean dumpEmpty = true;
    protected final int spaceHorizontal = 10;
    protected final int spaceVertical = 15;
    protected final int nodeHorizontal = 45;
    protected final int nodeVertical = 16;
    protected SimpleAttributeSet even;
    protected SimpleAttributeSet odd;
    protected SimpleAttributeSet actAttributes;
    protected Hashtable coordinates = new Hashtable();

    protected Color getBackgroundColorForNode(ViewGraphNode node) {
        Color bg = Color.black;
        if (node.getReteNode() instanceof TerminalNode) {
            bg = Color.black;
        }
        if (node.getReteNode() instanceof BaseJoin) {
            bg = Color.green;
        }
        if (node.getReteNode() instanceof LIANode) {
            bg = Color.cyan;
        }
        if (node.getReteNode() instanceof ObjectTypeNode) {
            bg = Color.orange;
        }
        if (node.getReteNode() instanceof AlphaNodePredConstr) {
            bg = Color.red;
        }
        if (node.getReteNode() instanceof BaseAlpha2) {
            bg = Color.red;
        }
        return bg;
    }

    protected Color getBorderColorForNode(ViewGraphNode node) {
        return this.getBackgroundColorForNode(node).darker();
    }

    protected void addPrimitive(Shape p) {
        this.container.addPrimitive(p);
        this.radar.addPrimitive(p);
    }

    protected void addPrimitive(ConnectorLine p) {
        this.container.addPrimitive(p);
        this.radar.addPrimitive(p);
    }

    protected void getCorrespondingTerminalNodes(ViewGraphNode root, Set target) {
        BaseNode n = root.getReteNode();
        if (n instanceof TerminalNode) {
            target.add(n);
        }
        for (ViewGraphNode succ : root.childs) {
            this.getCorrespondingTerminalNodes(succ, target);
        }
    }

    protected void setMyFrame(JFrame frame) {
        this.myFrame = frame;
    }

    protected Shape makeShapeFromNode(ViewGraphNode act, LinkedList<ViewGraphNode> queue) {
        Color bg = this.getBackgroundColorForNode(act);
        Color border = this.getBorderColorForNode(act);
        String desc = "";
        BaseNode reteNode = act.getReteNode();
        HashSet terminalNodes = new HashSet();
        this.getCorrespondingTerminalNodes(act, terminalNodes);
        if (reteNode != null) {
            desc = String.valueOf(reteNode.getNodeId());
        }
        Shape s = reteNode == null ? new Ellipse() : (reteNode instanceof BaseJoin || act.getReteNode() instanceof BaseAlpha2 ? new Trapezoid() : (reteNode instanceof TerminalNode ? new RoundedRectangle() : (reteNode instanceof LIANode ? new Ellipse() : new Rectangle())));
        s.setBgcolor(bg);
        s.setBordercolor(border);
        int x = 5 + (int)((double)(act.getX() * 55) / 2.0);
        int y = 7 + act.getY() * 31;
        String key = String.valueOf(x) + "," + y;
        while (this.coordinates.containsKey(key)) {
            key = String.valueOf(x += 110) + "," + y;
        }
        this.coordinates.put(key, s);
        s.setX(x);
        s.setY(y);
        s.setWidth(45);
        s.setHeight(16);
        String longdesc = "";
        if (reteNode == null) {
            longdesc = "Root Node";
        } else {
            longdesc = "ID:" + reteNode.getNodeId() + "  NodeType:" + reteNode.getClass().getSimpleName();
            longdesc = String.valueOf(longdesc) + "  Details:" + reteNode.toPPString();
        }
        longdesc = String.valueOf(longdesc) + "  Rules:";
        Iterator iter = terminalNodes.iterator();
        while (iter.hasNext()) {
            TerminalNode t = (TerminalNode)iter.next();
            longdesc = String.valueOf(longdesc) + t.getRule().getName();
            if (!iter.hasNext()) continue;
            longdesc = String.valueOf(longdesc) + ";";
        }
        s.setLongDescription(longdesc);
        if (reteNode instanceof LIANode) {
            s.incWidth(-15);
        }
        s.setText(desc);
        act.setShape(s);
        this.addPrimitive(s);
        for (ViewGraphNode n : act.getSuccessors()) {
            queue.offer(n);
        }
        return s;
    }

    protected void createPrimitives(ViewGraphNode root) {
        LinkedList<ViewGraphNode> queue = new LinkedList<ViewGraphNode>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            ViewGraphNode act = (ViewGraphNode)queue.poll();
            Shape s = null;
            s = act.getShape() == null ? this.makeShapeFromNode(act, queue) : act.getShape();
            if (act.isParentsChecked()) continue;
            act.setParentsChecked(true);
            for (ViewGraphNode n : act.getParents()) {
                Shape s1 = n.getShape();
                if (s1 == null) {
                    s1 = this.makeShapeFromNode(n, queue);
                }
                ConnectorLine line = new ConnectorLine(s1, s);
                line.setColor(Color.blue);
                if (n.getReteNode() instanceof BaseJoin) {
                    line.setColor(Color.red);
                }
                this.addPrimitive(line);
            }
        }
    }

    public Visualiser(Rete engine) {
        this.engine = engine;
        this.container = new JZoomableShapeContainer();
        this.container.addMouseListener(this);
        this.radar = new JMiniRadarShapeContainer();
        this.radar.setMasterShapeContainer(this.container);
        this.radar.setNormalizedFontHeight(16);
        this.container.setRadarShapeContainer(this.radar);
        this.calculateMainContainerFont();
        this.even = new SimpleAttributeSet();
        this.odd = new SimpleAttributeSet();
        StyleConstants.setForeground(this.even, Color.blue);
        StyleConstants.setForeground(this.odd, Color.green.darker());
        this.actAttributes = this.even;
        this.reloadView();
    }

    protected void calculateMainContainerFont() {
        int dpi = this.container.getToolkit().getScreenResolution();
        int ppMainContainer = (int)(16.0 * this.container.getZoomFactor() / (double)dpi * 72.0);
        this.container.setFont(new Font("SansSerif", 0, ppMainContainer));
    }

    public JPanel getVisualiserPanel() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(700, 450));
        JPanel toolBox = new JPanel();
        GridLayout toolBoxLayout = new GridLayout(2, 1);
        toolBox.setLayout(toolBoxLayout);
        this.zoomInButton = new JButton("Zoom In", IconLoader.getImageIcon("magnifier_zoom_in", Visualiser.class));
        this.zoomOutButton = new JButton("Zoom Out", IconLoader.getImageIcon("magnifier_zoom_out", Visualiser.class));
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.dump = new JTextPane();
        this.scrollPane = new JScrollPane(this.dump);
        this.dump.setText("This is the node dump area. Click on a node and you will get some information here\n");
        this.scrollPane.setAutoscrolls(true);
        JPanel dumpPanel = new JPanel(new BorderLayout());
        dumpPanel.add(this.scrollPane);
        JPanel sideBar = new JPanel(new BorderLayout());
        sideBar.add((Component)toolBox, "West");
        sideBar.add((Component)dumpPanel, "Center");
        panel.setLayout(new BorderLayout());
        JSplitPane sideSplitPane = new JSplitPane(1, this.radar, sideBar);
        JSplitPane mainSplitPane = new JSplitPane(0, this.container, sideSplitPane);
        mainSplitPane.setResizeWeight(1.0);
        mainSplitPane.setOneTouchExpandable(true);
        sideSplitPane.setOneTouchExpandable(true);
        panel.add((Component)mainSplitPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 1));
        buttonPanel.add(this.zoomInButton);
        buttonPanel.add(this.zoomOutButton);
        this.autoReloadButton = new JToggleButton("Automatic Reload", IconLoader.getImageIcon("arrow_refresh"));
        this.autoReloadButton.setSelected(false);
        this.autoReloadButton.addActionListener(this);
        buttonPanel.add(this.autoReloadButton);
        this.reloadButton = new JButton("Reload View", IconLoader.getImageIcon("arrow_refresh"));
        this.reloadButton.addActionListener(this);
        buttonPanel.add(this.reloadButton);
        panel.add((Component)buttonPanel, "Last");
        return panel;
    }

    public void show() {
        JFrame frame = new JFrame(this.getCaption(new Date()));
        frame.getContentPane().add((Component)this.getVisualiserPanel(), "Center");
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        frame.setSize(700, 500);
        this.setMyFrame(frame);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.zoomInButton) {
            this.container.zoomIn();
            this.calculateMainContainerFont();
            this.container.repaint();
        } else if (arg0.getSource() == this.zoomOutButton) {
            this.container.zoomOut();
            this.calculateMainContainerFont();
            this.container.repaint();
        } else if (arg0.getSource() == this.reloadButton) {
            this.reloadView();
        } else if (arg0.getSource() == this.autoReloadButton) {
            if (this.autoReloadButton.isSelected()) {
                this.reloadButton.setEnabled(false);
                this.engine.addEngineEventListener(this);
            } else {
                this.reloadButton.setEnabled(true);
                this.engine.removeEngineEventListener(this);
            }
        }
    }

    protected String getCaption(Date date) {
        return "Jamocha - Rete Network - " + DateFormat.getInstance().format(date);
    }

    protected void reloadView() {
        ViewGraphNode t;
        this.coordinates.clear();
        RootNode root = this.engine.getRootNode();
        this.root = t = ViewGraphNode.buildFromRete(root);
        this.container.removeAllPrimitives();
        this.radar.removeAllPrimitives();
        this.createPrimitives(t);
        if (this.myFrame != null) {
            this.myFrame.setTitle(this.getCaption(new Date()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void eventOccurred(EngineEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        Shape shape = this.container.getShapeAtPosition(event.getX(), event.getY());
        if (this.dumpEmpty) {
            this.dump.setText("");
            this.dumpEmpty = false;
        }
        if (shape == null) {
            return;
        }
        try {
            this.dump.getDocument().insertString(this.dump.getDocument().getLength(), String.valueOf(shape.getLongDescription()) + "\n", this.actAttributes);
            this.actAttributes = this.actAttributes == this.even ? this.odd : this.even;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

