/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.RootNode;
import org.jamocha.rete.visualisation.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewGraphNode {
    protected int subtreewidth = -1;
    protected BaseNode reteNode;
    protected boolean parentsChecked = false;
    protected Shape shape = null;
    protected ArrayList<ViewGraphNode> childs = new ArrayList();
    protected ArrayList<ViewGraphNode> parents = new ArrayList();
    protected int x = -1;
    protected int y = -1;

    public BaseNode getReteNode() {
        return this.reteNode;
    }

    public void setReteNode(BaseNode n) {
        this.reteNode = n;
    }

    protected void checkForValidAlignment() {
        if (this.x == -1) {
            ViewGraphNode r = this;
            while (!r.parents.isEmpty()) {
                r = this.parents.get(0);
            }
            r.calculateAlignment(0, 0);
        }
    }

    public int getX() {
        this.checkForValidAlignment();
        return this.x;
    }

    public int getY() {
        this.checkForValidAlignment();
        return this.y;
    }

    public int getHeight() {
        int h = 0;
        Iterator<ViewGraphNode> it = this.childs.iterator();
        while (it.hasNext()) {
            h = Math.max(h, it.next().getHeight());
        }
        return h + 1;
    }

    public int getWidth() {
        return this.getSubtreeWidth();
    }

    public ArrayList<ViewGraphNode> getSuccessors() {
        return this.childs;
    }

    public ArrayList<ViewGraphNode> getParents() {
        return this.parents;
    }

    protected void calculateAlignment(int offsetX, int offsetY) {
        this.x = this.getSubtreeWidth() / 2 - 1 + offsetX;
        if (this.x < offsetX) {
            this.x = offsetX;
        }
        this.y = offsetY++;
        for (ViewGraphNode sub : this.childs) {
            sub.calculateAlignment(offsetX, offsetY);
            offsetX += sub.getSubtreeWidth();
            if (sub.getSubtreeWidth() != 0) continue;
            offsetX += 2;
        }
    }

    protected void invalidateSubtreeWidth() {
        this.subtreewidth = -1;
        this.x = -1;
        this.y = -1;
        Iterator<ViewGraphNode> it = this.parents.iterator();
        while (it.hasNext()) {
            it.next().invalidateSubtreeWidth();
        }
    }

    public ViewGraphNode(BaseNode n) {
        this();
        this.setReteNode(n);
    }

    public static ViewGraphNode buildFromRete(RootNode root) {
        Collection firstLevel = root.getObjectTypeNodes().values();
        ViewGraphNode res = new ViewGraphNode();
        Hashtable<BaseNode, ViewGraphNode> ht = new Hashtable<BaseNode, ViewGraphNode>();
        for (BaseNode b : firstLevel) {
            res.addToChilds(ViewGraphNode.buildFromRete(b, ht));
        }
        return res;
    }

    protected static ViewGraphNode buildFromRete(BaseNode root, Hashtable<BaseNode, ViewGraphNode> ht) {
        Object[] succ = root.getSuccessorNodes();
        ViewGraphNode foo = ht.get(root);
        ViewGraphNode res = null;
        if (foo == null) {
            res = new ViewGraphNode(root);
            int i = 0;
            while (i < succ.length) {
                BaseNode nxtnode = (BaseNode)succ[i];
                if (nxtnode != null && nxtnode.getSuccessorNodes() != null) {
                    res.addToChilds(ViewGraphNode.buildFromRete(nxtnode, ht));
                }
                ++i;
            }
            ht.put(root, res);
        } else {
            res = foo;
        }
        return res;
    }

    public ViewGraphNode() {
    }

    public void addToChilds(BaseNode n) {
        ViewGraphNode node = new ViewGraphNode(n);
        this.childs.add(node);
        node.parents.add(this);
        this.invalidateSubtreeWidth();
    }

    public void addToChilds(ViewGraphNode n) {
        this.childs.add(n);
        n.parents.add(this);
        this.invalidateSubtreeWidth();
    }

    protected int getMyWidth(ViewGraphNode whichSubtree) {
        if (this.parents.get(0) == whichSubtree) {
            return 2;
        }
        return 0;
    }

    protected int getSubtreeWidth() {
        int r = 0;
        for (ViewGraphNode nxt : this.childs) {
            int myWidth = nxt.getMyWidth(this);
            int subtreeWidth = nxt.getSubtreeWidth();
            if (myWidth <= 0) continue;
            r += Math.max(myWidth, subtreeWidth);
        }
        return r;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public boolean isParentsChecked() {
        return this.parentsChecked;
    }

    public void setParentsChecked(boolean parentsChecked) {
        this.parentsChecked = parentsChecked;
    }
}

