/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.jamocha.rete.visualisation.Shape;

public class Trapezoid
extends Shape {
    protected double angleTopLeft;
    protected double angleTopRight;
    protected double angleBottomLeft;
    protected double angleBottomRight;

    public Trapezoid(Color bgcolor, Color bordercolor, int x, int y, int width, int height, String text) {
        super(bgcolor, bordercolor, x, y, width, height, text);
    }

    public Trapezoid() {
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.calculateCornerAngles();
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.calculateCornerAngles();
    }

    protected void calculateCornerAngles() {
        this.angleTopRight = Math.atan2(this.height, (double)this.width * 0.5);
        this.angleTopLeft = Math.PI - this.angleTopRight;
        this.angleBottomRight = -Math.atan2(this.height, this.width);
        this.angleBottomLeft = -this.angleTopLeft;
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY) {
        this.draw(canvas, offsetX, offsetY, 1.0, 1.0);
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY, double factorX, double factorY) {
        int ourX = (int)Math.round((double)(this.x - offsetX) * factorX);
        int ourY = (int)Math.round((double)(this.y - offsetY) * factorY);
        int ourWidth = (int)Math.round((double)this.width * factorX);
        int ourHeight = (int)Math.round((double)this.height * factorY);
        int[] xpoints = new int[]{ourX + (int)((double)ourWidth * 0.25), ourX + (int)((double)ourWidth * 0.75), ourX + ourWidth, ourX};
        int[] ypoints = new int[]{ourY, ourY, ourY + ourHeight, ourY + ourHeight};
        canvas.setColor(this.bgcolor);
        canvas.fillPolygon(xpoints, ypoints, 4);
        canvas.setColor(this.bordercolor);
        canvas.drawPolygon(xpoints, ypoints, 4);
        canvas.setColor(Color.black);
        if (this.bgcolor.getRGB() == Color.black.getRGB()) {
            canvas.setColor(Color.white);
        }
        if (ourHeight > 10) {
            Point textpos = this.calculateTextPosition(this.text, canvas, ourWidth, ourHeight);
            canvas.drawString(this.text, (int)textpos.getX() + ourX, (int)textpos.getY() + ourY);
        }
    }

    public void draw(Graphics2D canvas, double factorX, double factorY) {
        this.draw(canvas, 0, 0, factorX, factorY);
    }

    public Point calculateIntersection(double angle) {
        Point result = new Point();
        if (angle > this.angleTopLeft || angle < this.angleBottomLeft) {
            double alpha = angle > 0.0 ? Math.PI - angle : -angle - Math.PI;
            double dy = (Math.tan(alpha) * (double)this.width + (double)this.height) / 4.0;
            double dx = dy * (double)this.width / (4.0 * (double)this.height);
            result.x = (int)Math.round((double)this.x + dx);
            result.y = (int)Math.round(-dy + (double)this.y + (double)this.height);
        } else if (angle > this.angleTopRight) {
            double alpha = 1.5707963267948966 - angle;
            result.x = (int)Math.round(Math.tan(alpha) * (double)this.height * 0.5 + (double)this.x + (double)this.width * 0.5);
            result.y = this.y;
        } else if (angle > this.angleBottomRight) {
            double alpha = angle;
            double dy = (Math.tan(alpha) * (double)this.width + (double)this.height) / 4.0;
            double dx = dy * (double)this.width / (4.0 * (double)this.height);
            result.x = (int)Math.round((double)(this.x + this.width) - dx);
            result.y = (int)Math.round(-dy + (double)this.y + (double)this.height);
        } else {
            double alpha = 1.5707963267948966 + angle;
            result.x = (int)Math.round(Math.tan(alpha) * (double)this.height * 0.5 + (double)this.x + (double)this.width * 0.5);
            result.y = this.y + this.height;
        }
        return result;
    }
}

