/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import org.jamocha.rete.visualisation.Primitive;

public abstract class Shape
extends Primitive {
    protected Color bgcolor;
    protected Color bordercolor;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected String text;
    protected String longDescription;

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String val) {
        this.longDescription = val;
    }

    public void setBgcolor(Color bgcolor) {
        this.bgcolor = bgcolor;
    }

    public void setBordercolor(Color bordercolor) {
        this.bordercolor = bordercolor;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public Color getBordercolor() {
        return this.bordercolor;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void incHeight(int dh) {
        this.y -= dh / 2;
        this.height += dh;
    }

    public void incWidth(int dw) {
        this.x -= dw / 2;
        this.width += dw;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public abstract Point calculateIntersection(double var1);

    protected Point calculateTextPosition(String text, Graphics g, int width, int height) {
        int stringHeight = (int)g.getFontMetrics().getLineMetrics(text, g).getHeight();
        int stringWidth = g.getFontMetrics().stringWidth(text);
        int xpos = (width - stringWidth) / 2;
        int ypos = (height + stringHeight) / 2;
        return new Point(xpos, ypos);
    }

    Shape() {
    }

    Shape(Color bgcolor, Color bordercolor, int x, int y, int width, int height, String text) {
        this.bgcolor = bgcolor;
        this.bordercolor = bordercolor;
        this.x = x;
        this.y = y;
        this.setWidth(width);
        this.setHeight(height);
        this.text = text;
    }
}

