/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.jamocha.rete.visualisation.Shape;

public class RoundedRectangle
extends Shape {
    protected double angleTopLeft;
    protected double angleTopRight;
    protected double angleBottomLeft;
    protected double angleBottomRight;

    public RoundedRectangle(Color bgcolor, Color bordercolor, int x, int y, int width, int height, String text) {
        super(bgcolor, bordercolor, x, y, width, height, text);
    }

    public RoundedRectangle() {
    }

    public void setWidth(int width) {
        super.setWidth(width);
        this.calculateCornerAngles();
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.calculateCornerAngles();
    }

    protected void calculateCornerAngles() {
        this.angleTopRight = Math.atan2(this.height, this.width - this.height);
        this.angleTopLeft = Math.PI - this.angleTopRight;
        this.angleBottomRight = -this.angleTopRight;
        this.angleBottomLeft = -this.angleTopLeft;
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY) {
        this.draw(canvas, offsetX, offsetY, 1.0, 1.0);
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY, double factorX, double factorY) {
        int x = (int)Math.round((double)(this.x - offsetX) * factorX);
        int y = (int)Math.round((double)(this.y - offsetY) * factorY);
        int width = (int)Math.round((double)this.width * factorX);
        int height = (int)Math.round((double)this.height * factorY);
        canvas.setColor(this.bgcolor);
        canvas.fillOval(x, y, height + 1, height + 1);
        canvas.setColor(this.bordercolor);
        canvas.drawOval(x, y, height, height);
        canvas.setColor(this.bgcolor);
        canvas.fillOval(x + width - height, y, height + 1, height + 1);
        canvas.setColor(this.bordercolor);
        canvas.drawOval(x + width - height, y, height, height);
        canvas.setColor(this.bgcolor);
        canvas.fillRect(x + height / 2, y, width - height + 1, height + 1);
        canvas.setColor(this.bordercolor);
        canvas.drawLine(x + height / 2, y, x + width - height / 2, y);
        canvas.drawLine(x + height / 2, y + height + 1, x + width - height / 2, y + height + 1);
        canvas.setColor(Color.black);
        if (this.bgcolor.getRGB() == Color.black.getRGB()) {
            canvas.setColor(Color.white);
        }
        if (height > 10) {
            Point textpos = this.calculateTextPosition(this.text, canvas, width, height);
            canvas.drawString(this.text, (int)textpos.getX() + x, (int)textpos.getY() + y);
        }
    }

    public void draw(Graphics2D canvas, double factorX, double factorY) {
        this.draw(canvas, 0, 0, factorX, factorY);
    }

    public Point calculateIntersection(double angle) {
        Point result = new Point();
        if (angle > this.angleTopLeft || angle < this.angleBottomLeft) {
            double alpha = angle > 0.0 ? Math.PI - angle : -angle - Math.PI;
            double ys = Math.tan(alpha) * (double)(this.width - this.height) * 0.5;
            double newalpha = Math.PI - Math.acos(ys / (double)this.height);
            double x0 = (double)this.height * Math.cos(newalpha);
            double y0 = (double)this.height * Math.sin(newalpha);
            result.x = (int)Math.round((double)this.x + (double)this.height * 0.5 - x0);
            result.y = (int)Math.round((double)this.y + (double)this.height * 0.5 - y0);
        } else if (angle > this.angleTopRight) {
            double alpha = 1.5707963267948966 - angle;
            result.x = (int)Math.round(Math.tan(alpha) * (double)this.height * 0.5 + (double)this.x + (double)this.width * 0.5);
            result.y = this.y;
        } else if (angle > this.angleBottomRight) {
            double alpha = angle;
            double ys = Math.tan(alpha) * (double)(this.width - this.height) * 0.5;
            double newalpha = Math.PI - Math.acos(ys / (double)this.height);
            double x0 = (double)this.height * Math.cos(newalpha);
            double y0 = (double)this.height * Math.sin(newalpha);
            result.x = (int)Math.round((double)this.x + ((double)this.width - (double)this.height * 0.5) + x0);
            result.y = (int)Math.round((double)this.y + (double)this.height * 0.5 - y0);
        } else {
            double alpha = 1.5707963267948966 + angle;
            result.x = (int)Math.round(Math.tan(alpha) * (double)this.height * 0.5 + (double)this.x + (double)this.width * 0.5);
            result.y = this.y + this.height;
        }
        return result;
    }
}

