/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.Graphics2D;
import org.jamocha.rete.visualisation.JMiniRadarShapeContainer;
import org.jamocha.rete.visualisation.JShapeContainer;
import org.jamocha.rete.visualisation.Primitive;
import org.jamocha.rete.visualisation.Shape;

public class JZoomableShapeContainer
extends JShapeContainer {
    protected JMiniRadarShapeContainer radarShapeContainer;
    int zoomLevel = 0;

    public void zoomIn() {
        ++this.zoomLevel;
        this.repaint();
        if (this.radarShapeContainer != null) {
            this.radarShapeContainer.componentResized(null);
            this.radarShapeContainer.repaint();
        }
    }

    public void zoomOut() {
        --this.zoomLevel;
        this.repaint();
        if (this.radarShapeContainer != null) {
            this.radarShapeContainer.componentResized(null);
            this.radarShapeContainer.repaint();
        }
    }

    public double getZoomFactor() {
        double factor = 1.0;
        int i = 1;
        while (i <= this.zoomLevel) {
            factor *= 2.0;
            ++i;
        }
        i = -1;
        while (i >= this.zoomLevel) {
            factor /= 2.0;
            --i;
        }
        return factor;
    }

    protected void drawPrimitive(Primitive p, Graphics2D g) {
        double factor = this.getZoomFactor();
        p.draw(g, this.offsetX, this.offsetY, factor, factor);
    }

    public JMiniRadarShapeContainer getRadarShapeContainer() {
        return this.radarShapeContainer;
    }

    public void setRadarShapeContainer(JMiniRadarShapeContainer radarShapeContainer) {
        this.radarShapeContainer = radarShapeContainer;
    }

    public Shape getShapeAtPosition(int x, int y) {
        int rx = (int)Math.round((double)x / this.getZoomFactor() + (double)this.offsetX);
        int ry = (int)Math.round((double)y / this.getZoomFactor() + (double)this.offsetY);
        for (Shape s : this.shapes) {
            int offX = rx - s.getX();
            int offY = ry - s.getY();
            if (offX < 0 || offY < 0 || offX > s.getWidth() || offY > s.getHeight()) continue;
            return s;
        }
        return null;
    }
}

