/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jamocha.rete.visualisation.ConnectorLine;
import org.jamocha.rete.visualisation.Primitive;
import org.jamocha.rete.visualisation.Shape;

public class JShapeContainer
extends JComponent {
    protected List<ConnectorLine> lines = new ArrayList<ConnectorLine>();
    protected List<Shape> shapes = new ArrayList<Shape>();
    protected int graphwidth;
    protected int graphheight;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected Font font;

    public void setFont(Font f) {
        this.font = f;
    }

    public void addPrimitive(ConnectorLine c) {
        this.lines.add(c);
        Graphics2D gr = (Graphics2D)this.getGraphics();
        if (gr == null) {
            return;
        }
        this.drawPrimitive(c, gr);
    }

    public void addPrimitive(Shape s) {
        Graphics2D gr;
        this.shapes.add(s);
        if (s.width + s.x > this.graphwidth) {
            this.graphwidth = s.width + s.x;
        }
        if (s.height + s.y > this.graphheight) {
            this.graphheight = s.height + s.y;
        }
        if ((gr = (Graphics2D)this.getGraphics()) == null) {
            return;
        }
        this.drawPrimitive(s, gr);
    }

    public void removePrimitive(Primitive p) {
        if (p instanceof ConnectorLine) {
            this.lines.remove(p);
        }
        if (p instanceof Shape) {
            this.shapes.remove(p);
        }
        this.repaint();
    }

    public void removeAllPrimitives() {
        this.lines.clear();
        this.shapes.clear();
        this.repaint();
    }

    protected void drawPrimitive(Primitive p, Graphics2D g) {
        p.draw(g, this.offsetX, this.offsetY);
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public void paint(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setFont(this.font);
        Iterator<Shape> itshapes = this.shapes.iterator();
        Iterator<ConnectorLine> itarrows = this.lines.iterator();
        while (itshapes.hasNext()) {
            Shape s = itshapes.next();
            this.drawPrimitive(s, gr);
        }
        while (itarrows.hasNext()) {
            ConnectorLine l = itarrows.next();
            this.drawPrimitive(l, gr);
        }
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public Shape getShapeAtPosition(int x, int y) {
        for (Shape s : this.shapes) {
            int offX = x - s.getX();
            int offY = y - s.getY();
            if (offX < 0 || offY < 0 || offX > s.getWidth() || offY > s.getHeight()) continue;
            return s;
        }
        return null;
    }
}

