/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.jamocha.rete.visualisation.JShapeContainer;
import org.jamocha.rete.visualisation.JZoomableShapeContainer;
import org.jamocha.rete.visualisation.Primitive;
import org.jamocha.rete.visualisation.Shape;

public class JMiniRadarShapeContainer
extends JShapeContainer
implements MouseListener,
MouseMotionListener,
ComponentListener {
    protected JZoomableShapeContainer masterShapeContainer;
    protected int offsetX;
    protected int offsetY;
    protected int normalizedFontHeight;

    public JMiniRadarShapeContainer() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.offsetY = 0;
        this.offsetX = 0;
    }

    public void setNormalizedFontHeight(int h) {
        this.normalizedFontHeight = h;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Color clr = new Color(100, 100, 255, 100);
        g.setColor(clr);
        double zoomFactor = this.masterShapeContainer.getZoomFactor();
        double factorX = (double)this.getWidth() / ((double)this.graphwidth + 10.0);
        double factorY = (double)this.getHeight() / ((double)this.graphheight + 10.0);
        double factor = Math.min(factorX, factorY);
        int rectwidth = (int)((double)this.masterShapeContainer.getWidth() * factor / zoomFactor) + 1;
        int rectheight = (int)((double)this.masterShapeContainer.getHeight() * factor / zoomFactor) + 1;
        int rectx = (int)((double)this.offsetX * factor);
        int recty = (int)((double)this.offsetY * factor);
        g.fillRect(rectx, recty, rectwidth, rectheight);
    }

    public double getFactor() {
        double factorX = (double)this.getWidth() / ((double)this.graphwidth + 10.0);
        double factorY = (double)this.getHeight() / ((double)this.graphheight + 10.0);
        double factor = Math.min(factorX, factorY);
        return factor;
    }

    protected void drawPrimitive(Primitive p, Graphics2D g) {
        double factor = this.getFactor();
        p.draw(g, factor, factor);
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 100);
    }

    public void addPrimitive(Shape s) {
        super.addPrimitive(s);
        if (s.width + s.x > this.graphwidth) {
            this.graphwidth = s.width + s.x;
            this.repaint();
        }
        if (s.height + s.y > this.graphheight) {
            this.graphheight = s.height + s.y;
            this.repaint();
        }
    }

    public JShapeContainer getMasterShapeContainer() {
        return this.masterShapeContainer;
    }

    public void setMasterShapeContainer(JZoomableShapeContainer masterShapeContainer) {
        this.masterShapeContainer = masterShapeContainer;
        masterShapeContainer.addComponentListener(this);
    }

    public void mouseClicked(MouseEvent arg0) {
        this.radarNewPosition(arg0.getX(), arg0.getY());
    }

    public void mouseDragged(MouseEvent arg0) {
        this.mouseClicked(arg0);
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent arg0) {
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
    }

    protected void radarNewPosition(int x, int y) {
        double masterZoomFactor = this.masterShapeContainer.getZoomFactor();
        double myScalingFactor = this.getFactor();
        int x1 = (int)((double)x / myScalingFactor);
        int y1 = (int)((double)y / myScalingFactor);
        x1 = (int)((double)x1 - (double)(this.masterShapeContainer.getWidth() / 2) / masterZoomFactor);
        y1 = (int)((double)y1 - (double)(this.masterShapeContainer.getHeight() / 2) / masterZoomFactor);
        int offsetXmax = this.graphwidth + 10 - (int)((double)this.masterShapeContainer.getWidth() / masterZoomFactor);
        int offsetYmax = this.graphheight + 10 - (int)((double)this.masterShapeContainer.getHeight() / masterZoomFactor);
        if (x1 > offsetXmax) {
            x1 = offsetXmax;
        }
        if (y1 > offsetYmax) {
            y1 = offsetYmax;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        this.masterShapeContainer.setOffsetX(x1);
        this.masterShapeContainer.setOffsetY(y1);
        this.offsetX = x1;
        this.offsetY = y1;
        this.masterShapeContainer.repaint();
        this.repaint();
    }

    public void componentResized(ComponentEvent arg0) {
        boolean weHadToChangeOffset = false;
        double zoomFactor = this.masterShapeContainer.getZoomFactor();
        int offsetXmax = this.graphwidth + 10 - (int)((double)this.masterShapeContainer.getWidth() / zoomFactor);
        int offsetYmax = this.graphheight + 10 - (int)((double)this.masterShapeContainer.getHeight() / zoomFactor);
        if (this.offsetX > offsetXmax) {
            this.offsetX = offsetXmax;
            weHadToChangeOffset = true;
        }
        if (this.offsetY > offsetYmax) {
            this.offsetY = offsetYmax;
            weHadToChangeOffset = true;
        }
        if (this.offsetX < 0) {
            this.offsetX = 0;
            weHadToChangeOffset = true;
        }
        if (this.offsetY < 0) {
            this.offsetY = 0;
            weHadToChangeOffset = true;
        }
        if (weHadToChangeOffset) {
            this.masterShapeContainer.setOffsetX(this.offsetX);
            this.masterShapeContainer.setOffsetY(this.offsetY);
        }
        int dpi = this.getToolkit().getScreenResolution();
        int ppRadarContainer = (int)((double)this.normalizedFontHeight * this.getFactor() / (double)dpi * 72.0);
        this.setFont(new Font("SansSerif", 0, ppRadarContainer));
        this.repaint();
    }
}

