/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.jamocha.rete.visualisation.Shape;

public class Ellipse
extends Shape {
    public Ellipse(Color bgcolor, Color bordercolor, int x, int y, int width, int height, String text) {
        super(bgcolor, bordercolor, x, y, width, height, text);
    }

    public Ellipse() {
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY) {
        this.draw(canvas, offsetX, offsetY, 1.0, 1.0);
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY, double factorX, double factorY) {
        int x = (int)Math.round((double)(this.x - offsetX) * factorX);
        int y = (int)Math.round((double)(this.y - offsetY) * factorY);
        int width = (int)Math.round((double)this.width * factorX);
        int height = (int)Math.round((double)this.height * factorY);
        canvas.setColor(this.bgcolor);
        canvas.fillOval(x, y, width + 1, height + 1);
        canvas.setColor(this.bordercolor);
        canvas.drawOval(x, y, width, height);
        canvas.setColor(Color.black);
        if (this.bgcolor.getRGB() == Color.black.getRGB()) {
            canvas.setColor(Color.white);
        }
        if (height > 10) {
            Point textpos = this.calculateTextPosition(this.text, canvas, width, height);
            canvas.drawString(this.text, (int)textpos.getX() + x, (int)textpos.getY() + y);
        }
    }

    public void draw(Graphics2D canvas, double factorX, double factorY) {
        this.draw(canvas, 0, 0, factorX, factorY);
    }

    public Point calculateIntersection(double angle) {
        Point result = new Point();
        double r = Math.atan2(Math.sin(angle) * (double)this.width, Math.cos(angle) * (double)this.height);
        double xrel = Math.cos(r) * (double)this.width / 2.0;
        double yrel = Math.sin(r) * (double)this.height / 2.0;
        result.x = (int)Math.round(xrel + (double)this.x + (double)this.width * 0.5);
        result.y = (int)Math.round(-yrel + (double)this.y + (double)this.height * 0.5);
        return result;
    }
}

