/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.visualisation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.jamocha.rete.visualisation.Primitive;
import org.jamocha.rete.visualisation.Shape;

public class ConnectorLine
extends Primitive {
    private Shape from;
    private Shape to;
    private Color color;

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY) {
        this.draw(canvas, offsetX, offsetY, 1.0, 1.0);
    }

    public void draw(Graphics2D canvas, double factorX, double factorY) {
        this.draw(canvas, 0, 0, factorX, factorY);
    }

    public void draw(Graphics2D canvas, int offsetX, int offsetY, double factorX, double factorY) {
        canvas.setColor(this.color);
        double angleFromTo = Math.atan2(-this.to.getY() + this.from.getY(), this.to.getX() - this.from.getX());
        double angleToFrom = angleFromTo > 0.0 ? angleFromTo - Math.PI : angleFromTo + Math.PI;
        Point pfrom = this.from.calculateIntersection(angleFromTo);
        Point pto = this.to.calculateIntersection(angleToFrom);
        Point parrow1 = new Point((int)Math.round(6.0 * Math.cos(angleToFrom + 0.7853981633974483)), (int)Math.round(6.0 * Math.sin(angleToFrom + 0.7853981633974483)));
        Point parrow2 = new Point((int)Math.round(6.0 * Math.cos(angleToFrom - 0.7853981633974483)), (int)Math.round(6.0 * Math.sin(angleToFrom - 0.7853981633974483)));
        pfrom.x -= offsetX;
        pfrom.y -= offsetY;
        pto.x -= offsetX;
        pto.y -= offsetY;
        pfrom.x = (int)((double)pfrom.x * factorX);
        pfrom.y = (int)((double)pfrom.y * factorY);
        pto.x = (int)((double)pto.x * factorX);
        pto.y = (int)((double)pto.y * factorY);
        parrow1.x = (int)((double)parrow1.x * factorX);
        parrow1.y = (int)((double)parrow1.y * factorY);
        parrow2.x = (int)((double)parrow2.x * factorX);
        parrow2.y = (int)((double)parrow2.y * factorY);
        int linewidth = (int)Math.round(1.0 * Math.min(factorX, factorY));
        if (linewidth == 0) {
            linewidth = 1;
        }
        canvas.setStroke(new BasicStroke(linewidth));
        canvas.drawLine(pfrom.x, pfrom.y, pto.x, pto.y);
        canvas.drawLine(pto.x + parrow1.x, pto.y - parrow1.y, pto.x, pto.y);
        canvas.drawLine(pto.x + parrow2.x, pto.y - parrow2.y, pto.x, pto.y);
    }

    public ConnectorLine(Shape from, Shape to) {
        this.from = from;
        this.to = to;
    }
}

