/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.util;

import junit.framework.TestCase;
import org.jamocha.rete.util.HashMap;
import org.jamocha.rete.util.Iterator;

public class StringDataTest
extends TestCase {
    public void testIntegerData1() {
        int count = 10000;
        HashMap map = new HashMap();
        StringDataTest.assertNotNull((Object)map);
        int idx = 0;
        while (idx < count) {
            Integer key = new Integer(idx);
            Integer val = new Integer(idx);
            map.put(key, val);
            StringDataTest.assertEquals((Object)val, (Object)map.get(key));
            ++idx;
        }
    }

    public void testStringData1() {
        int count = 10000;
        HashMap map = new HashMap();
        StringDataTest.assertNotNull((Object)map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            StringDataTest.assertEquals((Object)strval, (Object)map.get(key));
            ++idx;
        }
    }

    public void testIterate() {
        int count = 10000;
        HashMap map = new HashMap();
        StringDataTest.assertNotNull((Object)map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        int counter = 0;
        Iterator itr = map.keyIterator();
        Object val = null;
        while ((val = itr.next()) != null) {
            StringDataTest.assertNotNull((Object)val);
            ++counter;
        }
        System.out.println("count = " + counter);
    }

    public void testStringData2() {
        int count = 100000;
        HashMap map = new HashMap();
        StringDataTest.assertNotNull((Object)map);
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom HashMap put ET - " + (end - start));
    }

    public void testJUHashMap1() {
        int count = 100000;
        java.util.HashMap<String, String> map = new java.util.HashMap<String, String>();
        StringDataTest.assertNotNull(map);
        long start = System.currentTimeMillis();
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap put ET - " + (end - start));
    }

    public void testStringData3() {
        int count = 100000;
        HashMap map = new HashMap();
        StringDataTest.assertNotNull((Object)map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < count) {
            String key = "key" + idx2;
            map.containsKey(key);
            ++idx2;
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom HashMap containsKey ET - " + (end - start));
    }

    public void testJUHashMap2() {
        int count = 100000;
        java.util.HashMap<String, String> map = new java.util.HashMap<String, String>();
        StringDataTest.assertNotNull(map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < count) {
            String key = "key" + idx2;
            map.containsKey(key);
            ++idx2;
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap containsKey ET - " + (end - start));
    }

    public void testStringData4() {
        int count = 100000;
        HashMap map = new HashMap();
        StringDataTest.assertNotNull((Object)map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < count) {
            String key = "key" + idx2;
            map.get(key);
            ++idx2;
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom HashMap get(key) ET - " + (end - start));
    }

    public void testJUHashMap3() {
        int count = 100000;
        java.util.HashMap<String, String> map = new java.util.HashMap<String, String>();
        StringDataTest.assertNotNull(map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        int idx2 = 0;
        while (idx2 < count) {
            String key = "key" + idx2;
            map.get(key);
            ++idx2;
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap get(key) ET - " + (end - start));
    }

    public void testStringData5() {
        int count = 100000;
        HashMap map = new HashMap();
        StringDataTest.assertNotNull((Object)map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        Iterator itr = map.keyIterator();
        Object val = null;
        while ((val = itr.next()) != null) {
            val.hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("Custom HashMap iterate ET - " + (end - start));
    }

    public void testJUHashMap4() {
        int count = 100000;
        java.util.HashMap<String, String> map = new java.util.HashMap<String, String>();
        StringDataTest.assertNotNull(map);
        int idx = 0;
        while (idx < count) {
            String key = "key" + idx;
            String strval = "value" + idx;
            map.put(key, strval);
            ++idx;
        }
        long start = System.currentTimeMillis();
        for (Object val : map.values()) {
            val.hashCode();
        }
        long end = System.currentTimeMillis();
        System.out.println("java.util.HashMap iterate ET - " + (end - start));
    }

    public static void main(String[] args) {
        StringDataTest test = new StringDataTest();
        int loop = 5;
        int idx = 0;
        while (idx < loop) {
            test.testIntegerData1();
            test.testStringData1();
            test.testIntegerData1();
            test.testStringData2();
            test.testJUHashMap1();
            test.testStringData3();
            test.testJUHashMap2();
            test.testStringData4();
            test.testJUHashMap3();
            test.testStringData5();
            test.testJUHashMap4();
            System.out.println(" ------------ ");
            ++idx;
        }
    }
}

