/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.util;

import java.lang.reflect.Method;
import org.jamocha.rete.Defclass;

public class ReflectionUtil {
    public static Method findMethod(Defclass dfclass, String name, Object[] parameters) {
        Method m = null;
        Class clazz = dfclass.getClassObject();
        Method[] methods = clazz.getMethods();
        int idx = 0;
        while (idx < methods.length) {
            Class[] mparams;
            if (methods[idx].getName().equals(name) && ReflectionUtil.compareParameters(mparams = methods[idx].getParameterTypes(), parameters)) {
                m = methods[idx];
                break;
            }
            ++idx;
        }
        return m;
    }

    public static boolean compareParameters(Class[] cparams, Object[] parameters) {
        if (cparams.length == parameters.length) {
            boolean equal = true;
            int idx = 0;
            while (idx < cparams.length) {
                Class left = cparams[idx];
                Class right = (Class)parameters[idx];
                if (!ReflectionUtil.compareClass(left, right)) {
                    equal = false;
                    break;
                }
                ++idx;
            }
            return equal;
        }
        return false;
    }

    public static boolean compareClass(Class left, Class right) {
        boolean equal = false;
        if (left == right) {
            return true;
        }
        if (left == String.class && right == Object.class) {
            return true;
        }
        if (left == String[].class && right == Object[].class) {
            return true;
        }
        return equal;
    }
}

