/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.util;

import org.jamocha.rete.util.AbstractMap;
import org.jamocha.rete.util.Entry;

public class HashMap
extends AbstractMap {
    public HashMap() {
        super(101, 0.75f);
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        int hashCode = this.comparator.hashCodeOf(key);
        int index = this.indexOf(hashCode, this.table.length);
        ObjectEntry current = (ObjectEntry)this.table[index];
        while (current != null) {
            if (hashCode == current.hashCode && this.comparator.equal(key, current.key)) {
                return current.value;
            }
            current = (ObjectEntry)current.getNext();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, false);
    }

    public Object put(Object key, Object value, boolean checkExists) {
        int hashCode = this.comparator.hashCodeOf(key);
        int index = this.indexOf(hashCode, this.table.length);
        if (checkExists) {
            Entry current = this.table[index];
            while (current != null) {
                if (hashCode == current.hashCode() && key.equals(current.getKey())) {
                    Object oldValue = current.getValue();
                    current.setValue(value);
                    return oldValue;
                }
                current = (ObjectEntry)current.getNext();
            }
        }
        ObjectEntry entry = new ObjectEntry(key, value, hashCode);
        entry.next = this.table[index];
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    public Object remove(Object key) {
        ObjectEntry previous;
        int hashCode = this.comparator.hashCodeOf(key);
        int index = this.indexOf(hashCode, this.table.length);
        ObjectEntry current = previous = (ObjectEntry)this.table[index];
        while (current != null) {
            ObjectEntry next = (ObjectEntry)current.getNext();
            if (hashCode == current.hashCode && this.comparator.equal(key, current.key)) {
                if (previous == current) {
                    this.table[index] = next;
                } else {
                    previous.setNext(next);
                }
                current.setNext(null);
                --this.size;
                return current.value;
            }
            previous = current;
            current = next;
        }
        return null;
    }

    public static class ObjectEntry
    implements Entry {
        private Object key;
        private Object value;
        private int hashCode;
        private Entry next;

        public ObjectEntry(Object key, Object value, int hashCode) {
            this.key = key;
            this.value = value;
            this.hashCode = hashCode;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object val) {
            this.value = val;
        }

        public Object getKey() {
            return this.key;
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public void clear() {
            this.key = null;
            this.value = null;
            this.next.clear();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            ObjectEntry other = (ObjectEntry)object;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }
    }
}

