/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.util;

import org.jamocha.rete.util.Entry;
import org.jamocha.rete.util.Iterator;
import org.jamocha.rete.util.Map;

public abstract class AbstractMap
implements Map {
    static final int MAX_CAPACITY = 0x40000000;
    protected int size;
    protected int threshold;
    protected float loadFactor;
    protected ObjectComparator comparator;
    protected Entry[] table;
    private EntryIterator eIterator;

    public AbstractMap(int capacity, float factor) {
        this.loadFactor = factor;
        this.threshold = (int)((float)capacity * this.loadFactor);
        this.table = new Entry[capacity];
        this.comparator = EqualityEquals.getInstance();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public abstract boolean containsKey(Object var1);

    public abstract Object get(Object var1);

    public abstract Object put(Object var1, Object var2);

    public abstract Object remove(Object var1);

    public void clear() {
        int idx = 0;
        while (idx < this.table.length) {
            if (this.table[idx] != null) {
                Entry e = this.table[idx];
                e.clear();
            }
            ++idx;
        }
        this.table = null;
        this.eIterator.reset();
    }

    public Iterator keyIterator() {
        if (this.eIterator == null) {
            this.eIterator = new EntryIterator(this);
        }
        this.eIterator.reset();
        return this.eIterator;
    }

    protected int indexOf(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    protected void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        int i = 0;
        while (i < this.table.length) {
            Entry entry = this.table[i];
            if (entry != null) {
                this.table[i] = null;
                Entry next = null;
                while (entry != null) {
                    next = entry.getNext();
                    int index = this.indexOf(entry.hashCode(), newTable.length);
                    entry.setNext(newTable[index]);
                    newTable[index] = entry;
                    entry = next;
                }
            }
            ++i;
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    public static class EntryIterator
    implements Iterator {
        private AbstractMap hashMap;
        private Entry[] table;
        private int row;
        private int length;
        private Entry entry;
        private Entry next;

        public EntryIterator(AbstractMap map) {
            this.hashMap = map;
        }

        public Object next() {
            if (this.entry == null) {
                while (this.entry == null) {
                    ++this.row;
                    if (this.row == this.length) {
                        return null;
                    }
                    this.entry = this.table[this.row];
                }
            } else {
                this.entry = this.entry.getNext();
                if (this.entry == null) {
                    this.entry = (Entry)this.next();
                }
            }
            return this.entry;
        }

        public void remove() {
            this.hashMap.remove(this.entry);
        }

        public void reset() {
            this.table = this.hashMap.table;
            this.length = this.table.length;
            this.row = -1;
            this.entry = null;
            this.next = null;
        }
    }

    public static class EqualityEquals
    implements ObjectComparator {
        public static ObjectComparator INSTANCE = new EqualityEquals();

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        public int hashCodeOf(Object key) {
            return this.rehash(key.hashCode());
        }

        public int rehash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        public boolean equal(Object object1, Object object2) {
            return object1.equals(object2);
        }
    }

    public static class InstanceEquals
    implements ObjectComparator {
        public static ObjectComparator INSTANCE = new InstanceEquals();

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        public int hashCodeOf(Object key) {
            return this.rehash(key.hashCode());
        }

        public int rehash(int h) {
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        public boolean equal(Object object1, Object object2) {
            return object1 == object2;
        }
    }

    public static interface ObjectComparator {
        public int hashCodeOf(Object var1);

        public int rehash(int var1);

        public boolean equal(Object var1, Object var2);
    }
}

