/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.strategies;

import java.io.Serializable;
import org.jamocha.rete.Activation;
import org.jamocha.rete.ActivationList;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Strategy;

public class RecencyStrategy
implements Strategy,
Serializable {
    private static final long serialVersionUID = 1L;

    public String getName() {
        return "recency";
    }

    public void addActivation(ActivationList thelist, Activation newActivation) {
        thelist.addActivation(newActivation);
    }

    public Activation nextActivation(ActivationList thelist) {
        return thelist.nextActivation();
    }

    public int compare(Activation left, Activation right) {
        if (right != null) {
            if (left.getRule().getSalience() == right.getRule().getSalience()) {
                return this.compareRecency(left, right);
            }
            if (left.getRule().getSalience() > right.getRule().getSalience()) {
                return 1;
            }
            return -1;
        }
        return 1;
    }

    protected int compareRecency(Activation left, Activation right) {
        int len;
        Fact[] lfacts = left.getFacts();
        Fact[] rfacts = right.getFacts();
        if (rfacts.length < (len = lfacts.length)) {
            len = rfacts.length;
        }
        int idx = 0;
        while (idx < len) {
            if (lfacts[idx].timeStamp() > rfacts[idx].timeStamp()) {
                return 1;
            }
            if (lfacts[idx].timeStamp() < rfacts[idx].timeStamp()) {
                return -1;
            }
            ++idx;
        }
        if (lfacts.length > rfacts.length) {
            return 1;
        }
        if (lfacts.length < rfacts.length) {
            return -1;
        }
        idx = 0;
        while (idx < len) {
            if (lfacts[idx].getFactId() > rfacts[idx].getFactId()) {
                return 1;
            }
            if (lfacts[idx].getFactId() < rfacts[idx].getFactId()) {
                return -1;
            }
            ++idx;
        }
        return 0;
    }
}

