/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import java.io.Serializable;
import java.util.Map;
import org.jamocha.rete.Constants;
import org.jamocha.rete.Fact;
import org.jamocha.rete.ObjectTypeNode;
import org.jamocha.rete.Rete;
import org.jamocha.rete.RootNode;
import org.jamocha.rete.Template;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.exception.RetractException;
import org.jamocha.rete.query.QueryObjTypeNode;
import org.jamocha.rule.Defquery;

public class QueryRootNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map queryObjTypeNodeMap = null;
    protected RootNode root = null;
    protected QueryObjTypeNode initialFactObjTypeNode = null;

    public QueryRootNode(Rete engine, RootNode root) {
        this.queryObjTypeNodeMap = engine.newMap();
        this.root = root;
    }

    public void addQueryObjTypeNode(QueryObjTypeNode node) {
        if (node.getDeftemplate().getName().equals(Constants.INITIAL_FACT)) {
            this.initialFactObjTypeNode = node;
        } else if (!this.queryObjTypeNodeMap.containsKey(node.getDeftemplate())) {
            this.queryObjTypeNodeMap.put(node.getDeftemplate(), node);
        }
    }

    public void removeQueryObjTypeNode(QueryObjTypeNode node) {
        this.queryObjTypeNodeMap.remove(node.getDeftemplate());
    }

    public Map getQueryObjTypeNodes() {
        return this.queryObjTypeNodeMap;
    }

    public QueryObjTypeNode findQueryObjTypeNode(Template template) {
        return (QueryObjTypeNode)this.queryObjTypeNodeMap.get(template);
    }

    public synchronized void assertObject(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        for (Template template : this.queryObjTypeNodeMap.keySet()) {
            QueryObjTypeNode qotn = (QueryObjTypeNode)this.queryObjTypeNodeMap.get(template);
            if (qotn != null) {
                qotn.assertFact(null, engine, mem);
            }
            if (template.getParent() == null) continue;
            this.assertObjectParent(template.getParent(), engine, mem);
        }
    }

    public synchronized void assertObjectParent(Template template, Rete engine, WorkingMemory mem) throws AssertException {
        QueryObjTypeNode otn = (QueryObjTypeNode)this.queryObjTypeNodeMap.get(template);
        if (otn != null) {
            otn.assertFact(null, engine, mem);
        }
        if (template.getParent() != null) {
            this.assertObjectParent(template.getParent(), engine, mem);
        }
    }

    public synchronized void retractObject(Fact fact, Rete engine, WorkingMemory mem) throws RetractException {
    }

    public synchronized void retractObjectParent(Fact fact, Template template, Rete engine, WorkingMemory mem) throws RetractException {
    }

    public synchronized void clear() {
        for (ObjectTypeNode otn : this.queryObjTypeNodeMap.values()) {
            otn.clearSuccessors();
        }
        this.queryObjTypeNodeMap.clear();
    }

    public QueryRootNode clone(Rete engine, Defquery query) {
        QueryRootNode clone = new QueryRootNode(engine, this.root);
        for (QueryObjTypeNode qotn : this.queryObjTypeNodeMap.values()) {
            clone.addQueryObjTypeNode(qotn.clone(engine, query));
        }
        clone.initialFactObjTypeNode = this.initialFactObjTypeNode;
        return clone;
    }
}

