/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.Slot2;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseAlphaCondition;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rule.Defquery;

public class QueryOrAlphaNode
extends QueryBaseAlphaCondition {
    private static final long serialVersionUID = 1L;
    protected int useCount = 0;

    public QueryOrAlphaNode(int id) {
        super(id);
    }

    public boolean isShared() {
        return this.useCount > 0;
    }

    public void setSlot(Slot sl) {
        this.slot = (Slot2)sl;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void incrementUseCount() {
        ++this.useCount;
    }

    public void decrementUseCount() {
        --this.useCount;
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(fact)) {
            this.propogateAssert(fact, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance) {
        boolean not = ((Slot2)this.slot).getNotEqualList().contains(factInstance.getSlotValue(this.slot.getId()));
        boolean eq = ((Slot2)this.slot).getEqualList().contains(factInstance.getSlotValue(this.slot.getId()));
        return !not && eq;
    }

    public void setOperator(int opr) {
    }

    public String hashString() {
        return this.toString();
    }

    public String toString() {
        return "slot(" + this.slot.getName() + ") " + ((Slot2)this.slot).toString("|") + " - useCount=" + this.useCount;
    }

    public String toPPString() {
        return "or node-" + this.nodeID + "> slot(" + this.slot.getName() + ") " + ((Slot2)this.slot).toString("|") + " - useCount=" + this.useCount;
    }

    public QueryBaseAlpha clone(Rete engine, Defquery query) {
        QueryOrAlphaNode clone = new QueryOrAlphaNode(engine.nextNodeId());
        clone.operator = this.operator;
        clone.slot = (Slot)this.slot.clone();
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        int i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        return clone;
    }
}

