/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.BetaMemoryImpl;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryBaseNot;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rule.Defquery;

public class QueryNotJoin
extends QueryBaseNot {
    private static final long serialVersionUID = 1L;

    public QueryNotJoin(int id) {
        super(id);
    }

    public void clear(WorkingMemory mem) {
        Map rightmem = (Map)mem.getQueryRightMemory(this);
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        BetaMemoryImpl bmem = new BetaMemoryImpl(linx, engine);
        leftmem.put(bmem.getIndex(), bmem);
        Map rightmem = (Map)mem.getQueryRightMemory(this);
        for (Fact rfcts : rightmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfcts, engine)) continue;
            bmem.addMatch(rfcts);
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        Map rightmem = (Map)mem.getQueryRightMemory(this);
        rightmem.put(rfact, rfact);
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        for (BetaMemory bmem : leftmem.values()) {
            Index linx = bmem.getIndex();
            if (!this.evaluate(linx.getFacts(), rfact, engine)) continue;
            bmem.addMatch(rfact);
        }
    }

    public void executeJoin(Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getBetaLeftMemory(this);
        for (BetaMemory bmem : leftmem.values()) {
            if (bmem.matchCount() != 0) continue;
            this.propogateAssert(bmem.getIndex(), engine, mem);
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right, Rete engine) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd instanceof Binding ? ((Binding2)bnd).evaluate(leftlist, right, engine) : bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NOT CE - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("node-" + this.nodeID + "> NOT CE - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toPPString());
            ++idx;
        }
        return buf.toString();
    }

    public QueryNotJoin clone(Rete engine, Defquery query) {
        QueryNotJoin clone = new QueryNotJoin(engine.nextNodeId());
        Binding[] cloneBinding = new Binding[this.binds.length];
        int i = 0;
        while (i < this.binds.length) {
            cloneBinding[i] = (Binding)this.binds[i].clone();
            ++i;
        }
        clone.binds = cloneBinding;
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        query.addNotNode(clone);
        return clone;
    }
}

