/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import java.util.Map;
import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BetaMemoryImpl;
import org.jamocha.rete.Binding;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Index;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.functions.ShellFunction;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rule.Defquery;

public class QueryNTestNode
extends QueryBaseJoin {
    private static final long serialVersionUID = 1L;
    protected Function func = null;
    protected Parameter[] params = null;
    private String ppstring = null;

    public QueryNTestNode(int id, Function func, Parameter[] parameters) {
        super(id);
        this.func = func;
        this.params = parameters;
    }

    public void lookUpFunction(Rete engine) {
        if (this.func instanceof ShellFunction) {
            ShellFunction sf = (ShellFunction)this.func;
            sf.lookUpFunction(engine);
            if (sf.getFunction() != null) {
                this.func = sf.getFunction();
            }
        }
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        if (!leftmem.containsKey(linx)) {
            this.setParameters(linx.getFacts());
            ReturnVector rv = this.func.executeFunction(engine, this.params);
            if (!rv.firstReturnValue().getBooleanValue()) {
                BetaMemoryImpl bmem = new BetaMemoryImpl(linx, engine);
                leftmem.put(bmem.getIndex(), bmem);
            }
            if (leftmem.size() == 0) {
                this.propogateAssert(linx, engine, mem);
            }
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) {
    }

    public void setBindings(Binding[] binds) {
    }

    public void retractRight(Fact rfact, Rete engine, WorkingMemory mem) {
    }

    public void clear(WorkingMemory mem) {
        ((Map)mem.getBetaLeftMemory(this)).clear();
    }

    protected void setParameters(Fact[] facts) {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx] instanceof BoundParam) {
                ((BoundParam)this.params[idx]).setFact(facts);
            } else if (this.params[idx] instanceof FunctionParam) {
                ((FunctionParam)this.params[idx]).setFacts(facts);
            }
            ++idx;
        }
    }

    public String toString() {
        return "(test (" + this.func.getName() + ") )";
    }

    public String toPPString() {
        if (this.ppstring == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("TestNode-" + this.nodeID + "> (test (" + this.func.getName());
            int idx = 0;
            while (idx < this.params.length) {
                if (this.params[idx] instanceof BoundParam) {
                    BoundParam bp = (BoundParam)this.params[idx];
                    buf.append(" ?" + bp.getVariableName());
                } else if (this.params[idx] instanceof ValueParam) {
                    ValueParam vp = (ValueParam)this.params[idx];
                    buf.append(" " + vp.getStringValue());
                }
                ++idx;
            }
            buf.append(") )");
            this.ppstring = buf.toString();
        }
        return this.ppstring;
    }

    public QueryNTestNode clone(Rete engine, Defquery query) {
        Parameter[] cloneParams = new Parameter[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            AbstractParam fp;
            if (this.params[i] instanceof BoundParam) {
                BoundParam bp = (BoundParam)this.params[i];
                cloneParams[i] = bp.clone();
            } else if (this.params[i] instanceof ValueParam) {
                ValueParam vp = (ValueParam)this.params[i];
                cloneParams[i] = vp.cloneParameter();
            } else if (this.params[i] instanceof FunctionParam) {
                fp = (FunctionParam)this.params[i];
                cloneParams[i] = ((FunctionParam)fp).clone();
            } else if (this.params[i] instanceof FunctionParam2) {
                fp = (FunctionParam2)this.params[i];
                cloneParams[i] = ((FunctionParam2)fp).clone();
            }
            ++i;
        }
        QueryNTestNode clone = new QueryNTestNode(engine.nextNodeId(), this.func, cloneParams);
        Binding[] cloneBinding = new Binding[this.binds.length];
        int i2 = 0;
        while (i2 < this.binds.length) {
            cloneBinding[i2] = (Binding)this.binds[i2].clone();
            ++i2;
        }
        clone.binds = cloneBinding;
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        i2 = 0;
        while (i2 < this.successorNodes.length) {
            if (this.successorNodes[i2] instanceof QueryBaseAlpha) {
                clone.successorNodes[i2] = ((QueryBaseAlpha)this.successorNodes[i2]).clone(engine, query);
            } else if (this.successorNodes[i2] instanceof QueryBaseJoin) {
                clone.successorNodes[i2] = ((QueryBaseJoin)this.successorNodes[i2]).clone(engine, query);
            } else if (this.successorNodes[i2] instanceof QueryResultNode) {
                clone.successorNodes[i2] = ((QueryResultNode)this.successorNodes[i2]).clone(engine, query);
            }
            ++i2;
        }
        return clone;
    }
}

