/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseAlphaCondition;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rule.Defquery;

public class QueryIntraFactNode
extends QueryBaseAlphaCondition {
    private static final long serialVersionUID = 1L;
    private Slot leftSlot = null;
    private Slot rightSlot = null;
    protected String hashstring = null;

    public QueryIntraFactNode(int id) {
        super(id);
    }

    public void setOperator(int opr) {
        this.operator = opr;
    }

    public void setSlot(Slot sl) {
        this.leftSlot = sl;
    }

    public void setRightSlot(Slot sl) {
        this.rightSlot = sl;
    }

    public void assertFact(Fact factInstance, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(factInstance)) {
            this.propogateAssert(factInstance, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance) {
        return Evaluate.evaluate(this.operator, factInstance.getSlotValue(this.leftSlot.getId()), factInstance.getSlotValue(this.rightSlot.getId()));
    }

    public String hashString() {
        if (this.hashstring == null) {
            this.hashstring = String.valueOf(this.leftSlot.getName()) + ":" + this.operator + ":" + this.rightSlot.getName();
        }
        return this.hashstring;
    }

    public String toPPString() {
        return String.valueOf(this.leftSlot.getName()) + " " + ConversionUtils.getPPOperator(this.operator) + " " + this.rightSlot.getName() + " - useCount=" + this.useCount;
    }

    public String toString() {
        return String.valueOf(this.leftSlot.getName()) + " " + ConversionUtils.getPPOperator(this.operator) + " " + this.rightSlot.getName() + " - useCount=" + this.useCount;
    }

    public QueryBaseAlpha clone(Rete engine, Defquery query) {
        QueryIntraFactNode clone = new QueryIntraFactNode(engine.nextNodeId());
        clone.operator = this.operator;
        clone.leftSlot = (Slot)this.leftSlot.clone();
        clone.rightSlot = (Slot)this.rightSlot.clone();
        int i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        return clone;
    }
}

