/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedNeqAlphaMemory;
import org.jamocha.rete.Index;
import org.jamocha.rete.NotEqHashIndex;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rete.util.NodeUtils;
import org.jamocha.rule.Defquery;

public class QueryHashedNeqJoin
extends QueryBaseJoin {
    private static final long serialVersionUID = 1L;

    public QueryHashedNeqJoin(int id) {
        super(id);
    }

    public void clear(WorkingMemory mem) {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        HashedNeqAlphaMemory rightmem = (HashedNeqAlphaMemory)mem.getQueryRightMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        leftmem.put(linx, linx);
        NotEqHashIndex inx = new NotEqHashIndex(NodeUtils.getLeftBindValues(this.binds, linx.getFacts()));
        HashedNeqAlphaMemory rightmem = (HashedNeqAlphaMemory)mem.getQueryRightMemory(this);
        Object[] objs = rightmem.iterator(inx);
        if (objs != null && objs.length > 0) {
            int idx = 0;
            while (idx < objs.length) {
                Fact rfcts = (Fact)objs[idx];
                this.propogateAssert(linx.add(rfcts), engine, mem);
                ++idx;
            }
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        HashedNeqAlphaMemory rightmem = (HashedNeqAlphaMemory)mem.getQueryRightMemory(this);
        NotEqHashIndex inx = new NotEqHashIndex(NodeUtils.getRightBindValues(this.binds, rfact));
        rightmem.addPartialMatch(inx, rfact, engine);
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact)) continue;
            this.propogateAssert(linx.add(rfact), engine, mem);
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashedNotEqBNode-" + this.nodeID + "> ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }

    public QueryHashedNeqJoin clone(Rete engine, Defquery query) {
        QueryHashedNeqJoin clone = new QueryHashedNeqJoin(engine.nextNodeId());
        Binding[] cloneBinding = new Binding[this.binds.length];
        int i = 0;
        while (i < this.binds.length) {
            cloneBinding[i] = (Binding)this.binds[i].clone();
            ++i;
        }
        clone.binds = cloneBinding;
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        return clone;
    }
}

