/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import java.util.Map;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.Binding;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryBaseNot;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rete.util.NodeUtils;
import org.jamocha.rule.Defquery;

public class QueryHashedEqNot
extends QueryBaseNot {
    private static final long serialVersionUID = 1L;

    public QueryHashedEqNot(int id) {
        super(id);
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        leftmem.put(linx, linx);
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getQueryRightMemory(this);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        rightmem.addPartialMatch(inx, rfact, engine);
    }

    public void executeJoin(Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        for (Index index : leftmem.values()) {
            EqHashIndex inx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, index.getFacts()));
            HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getQueryRightMemory(this);
            if (rightmem.count(inx) != 0) continue;
            this.propogateAssert(index, engine, mem);
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashedEqNJoin- ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashedEqNJoin-" + this.nodeID + "> ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toPPString());
            ++idx;
        }
        return buf.toString();
    }

    public QueryHashedEqNot clone(Rete engine, Defquery query) {
        QueryHashedEqNot clone = new QueryHashedEqNot(engine.nextNodeId());
        Binding[] cloneBinding = new Binding[this.binds.length];
        int i = 0;
        while (i < this.binds.length) {
            cloneBinding[i] = (Binding)this.binds[i].clone();
            ++i;
        }
        clone.binds = cloneBinding;
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        query.addNotNode(clone);
        return clone;
    }
}

