/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.BetaMemoryImpl;
import org.jamocha.rete.Binding;
import org.jamocha.rete.Binding2;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rule.Defquery;

public class QueryFuncJoin
extends QueryBaseJoin {
    private static final long serialVersionUID = 1L;

    public QueryFuncJoin(int id) {
        super(id);
    }

    public void setBindings(Binding[] binds) {
        this.binds = binds;
    }

    public void clear(WorkingMemory mem) {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getQueryRightMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        BetaMemoryImpl bmem = new BetaMemoryImpl(linx, engine);
        leftmem.put(linx, bmem);
        Map rightmem = (Map)mem.getQueryRightMemory(this);
        Iterator itr = rightmem.keySet().iterator();
        if (itr != null) {
            while (itr.hasNext()) {
                Fact vl = (Fact)itr.next();
                if (vl == null || !this.evaluate(linx.getFacts(), vl, engine)) continue;
                bmem.addMatch(vl);
                this.propogateAssert(linx.add(vl), engine, mem);
            }
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        Map rightmem = (Map)mem.getQueryBetaMemory(this);
        rightmem.put(rfact, rfact);
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        for (BetaMemory bmem : leftmem.values()) {
            if (!this.evaluate(bmem.getLeftFacts(), rfact, engine)) continue;
            bmem.addMatch(rfact);
            this.propogateAssert(bmem.getIndex().add(rfact), engine, mem);
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right, Rete engine) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd instanceof Binding2 ? ((Binding2)bnd).evaluate(leftlist, right, engine) : bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PredicateBNode-" + this.nodeID + "> ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            if (this.binds[idx] != null) {
                buf.append(this.binds[idx].toPPString());
            }
            ++idx;
        }
        return buf.toString();
    }

    public QueryFuncJoin clone(Rete engine, Defquery query) {
        QueryFuncJoin clone = new QueryFuncJoin(engine.nextNodeId());
        Binding[] cloneBinding = new Binding[this.binds.length];
        int i = 0;
        while (i < this.binds.length) {
            cloneBinding[i] = (Binding)this.binds[i].clone();
            ++i;
        }
        clone.binds = cloneBinding;
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        return clone;
    }
}

