/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import org.jamocha.rete.AbstractParam;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.CompositeIndex;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnValue;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.Slot;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseAlphaCondition;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rule.Defquery;

public class QueryFuncAlphaNode
extends QueryBaseAlphaCondition {
    private static final long serialVersionUID = 1L;
    protected Function function = null;
    protected String hashstring = null;
    protected Parameter[] params = null;
    protected String parameterName = null;
    protected CompositeIndex compIndex = null;

    public QueryFuncAlphaNode(int id, Function func, Parameter[] params, Slot slot) {
        super(id);
        this.function = func;
        this.params = params;
        this.slot = slot;
    }

    public void setSlot(Slot sl) {
        this.slot = sl;
    }

    public void setOperator(int opr) {
        this.operator = opr;
    }

    public void setParameterName(String name) {
        this.parameterName = name;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setQueryParameterValue(Object value) {
        this.slot.setValue(value);
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(fact, engine)) {
            this.propogateAssert(fact, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance, Rete engine) {
        int idx = 0;
        while (idx < this.params.length) {
            if (this.params[idx] instanceof BoundParam) {
                ((BoundParam)this.params[idx]).setFact(new Fact[]{factInstance});
            } else if (this.params[idx] instanceof FunctionParam2) {
                ((FunctionParam2)this.params[idx]).setFacts(new Fact[]{factInstance});
            }
            ++idx;
        }
        ReturnVector rv = this.function.executeFunction(engine, this.params);
        ReturnValue rval = rv.firstReturnValue();
        return rval.getBooleanValue();
    }

    public String hashString() {
        if (this.hashstring == null) {
            this.hashstring = String.valueOf(this.slot.getId()) + ":" + this.operator + ":" + String.valueOf(this.slot.getValue());
        }
        return this.hashstring;
    }

    public String toString() {
        return "slot(" + this.slot.getId() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + this.slot.getValue().toString() + " - useCount=" + this.useCount;
    }

    public String toPPString() {
        if (this.function != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("node-" + this.nodeID + "> slot(" + this.slot.getName() + ") ");
            buf.append(this.function.toPPString(this.params, 1));
            buf.append(" - useCount=" + this.useCount);
            return buf.toString();
        }
        return "node-" + this.nodeID + "> slot(" + this.slot.getName() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + ConversionUtils.formatSlot(this.slot.getValue()) + " - useCount=" + this.useCount;
    }

    public QueryBaseAlpha clone(Rete engine, Defquery query) {
        Parameter[] cloneParams = new Parameter[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            AbstractParam fp;
            if (this.params[i] instanceof BoundParam) {
                BoundParam bp = (BoundParam)this.params[i];
                cloneParams[i] = bp.clone();
            } else if (this.params[i] instanceof ValueParam) {
                ValueParam vp = (ValueParam)this.params[i];
                cloneParams[i] = vp.cloneParameter();
            } else if (this.params[i] instanceof FunctionParam) {
                fp = (FunctionParam)this.params[i];
                cloneParams[i] = ((FunctionParam)fp).clone();
            } else if (this.params[i] instanceof FunctionParam2) {
                fp = (FunctionParam2)this.params[i];
                cloneParams[i] = ((FunctionParam2)fp).clone();
            }
            ++i;
        }
        QueryFuncAlphaNode clone = new QueryFuncAlphaNode(engine.nextNodeId(), this.function, cloneParams, (Slot)this.slot.clone());
        clone.operator = this.operator;
        clone.parameterName = this.parameterName;
        clone.useCount = this.useCount;
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        int i2 = 0;
        while (i2 < this.successorNodes.length) {
            if (this.successorNodes[i2] instanceof QueryBaseAlpha) {
                clone.successorNodes[i2] = ((QueryBaseAlpha)this.successorNodes[i2]).clone(engine, query);
            } else if (this.successorNodes[i2] instanceof QueryBaseJoin) {
                clone.successorNodes[i2] = ((QueryBaseJoin)this.successorNodes[i2]).clone(engine, query);
            } else if (this.successorNodes[i2] instanceof QueryResultNode) {
                clone.successorNodes[i2] = ((QueryResultNode)this.successorNodes[i2]).clone(engine, query);
            }
            ++i2;
        }
        query.addQueryFuncNode(clone);
        return clone;
    }
}

