/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import java.util.Iterator;
import java.util.Map;
import org.jamocha.rete.BaseNode;
import org.jamocha.rete.BetaMemory;
import org.jamocha.rete.Binding;
import org.jamocha.rete.EqHashIndex;
import org.jamocha.rete.Fact;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rete.util.NodeUtils;
import org.jamocha.rule.Defquery;

public class QueryExistJoin
extends QueryBaseJoin {
    private static final long serialVersionUID = 1L;

    public QueryExistJoin(int id) {
        super(id);
    }

    public void clear(WorkingMemory mem) {
        Map rightmem = (Map)mem.getQueryRightMemory(this);
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        Iterator itr = leftmem.keySet().iterator();
        while (itr.hasNext()) {
            BetaMemory bmem = (BetaMemory)leftmem.get(itr.next());
            bmem.clear();
        }
        leftmem.clear();
        rightmem.clear();
    }

    public void assertLeft(Index linx, Rete engine, WorkingMemory mem) throws AssertException {
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        leftmem.put(linx, linx);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getLeftValues(this.binds, linx.getFacts()));
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getQueryRightMemory(this);
        if (rightmem.count(inx) > 0) {
            this.propogateAssert(linx, engine, mem);
        }
    }

    public void assertRight(Fact rfact, Rete engine, WorkingMemory mem) throws AssertException {
        HashedAlphaMemoryImpl rightmem = (HashedAlphaMemoryImpl)mem.getQueryRightMemory(this);
        EqHashIndex inx = new EqHashIndex(NodeUtils.getRightValues(this.binds, rfact));
        int after = rightmem.addPartialMatch(inx, rfact, engine);
        Map leftmem = (Map)mem.getQueryBetaMemory(this);
        for (Index linx : leftmem.values()) {
            if (!this.evaluate(linx.getFacts(), rfact) || after != 1) continue;
            this.propogateAssert(linx, engine, mem);
        }
    }

    public boolean evaluate(Fact[] leftlist, Fact right) {
        boolean eval = true;
        int idx = 0;
        while (idx < this.binds.length) {
            Binding bnd = this.binds[idx];
            eval = bnd.evaluate(leftlist, right);
            if (!eval) break;
            ++idx;
        }
        return eval;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Exist - ");
        int idx = 0;
        while (idx < this.binds.length) {
            if (idx > 0) {
                buf.append(" && ");
            }
            buf.append(this.binds[idx].toBindString());
            ++idx;
        }
        return buf.toString();
    }

    public String toPPString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<node-" + this.nodeID + "> Exist - ");
        if (this.binds != null && this.binds.length > 0) {
            int idx = 0;
            while (idx < this.binds.length) {
                if (idx > 0) {
                    buf.append(" && ");
                }
                buf.append(this.binds[idx].toPPString());
                ++idx;
            }
        } else {
            buf.append(" no joins ");
        }
        return buf.toString();
    }

    public QueryExistJoin clone(Rete engine, Defquery query) {
        QueryExistJoin clone = new QueryExistJoin(engine.nextNodeId());
        Binding[] cloneBinding = new Binding[this.binds.length];
        int i = 0;
        while (i < this.binds.length) {
            cloneBinding[i] = (Binding)this.binds[i].clone();
            ++i;
        }
        clone.binds = cloneBinding;
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        return clone;
    }
}

