/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.query;

import org.jamocha.rete.BaseNode;
import org.jamocha.rete.CompositeIndex;
import org.jamocha.rete.ConversionUtils;
import org.jamocha.rete.Evaluate;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Slot;
import org.jamocha.rete.WorkingMemory;
import org.jamocha.rete.exception.AssertException;
import org.jamocha.rete.query.QueryBaseAlpha;
import org.jamocha.rete.query.QueryBaseAlphaCondition;
import org.jamocha.rete.query.QueryBaseJoin;
import org.jamocha.rete.query.QueryResultNode;
import org.jamocha.rule.Defquery;

public class QueryAlphaNode
extends QueryBaseAlphaCondition {
    private static final long serialVersionUID = 1L;
    protected String hashstring = null;
    protected CompositeIndex compIndex = null;

    public QueryAlphaNode(int id) {
        super(id);
    }

    public void setOperator(int opr) {
        this.operator = opr;
    }

    public boolean isShared() {
        return this.useCount > 0;
    }

    public void setSlot(Slot sl) {
        this.slot = sl;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public void assertFact(Fact fact, Rete engine, WorkingMemory mem) throws AssertException {
        if (this.evaluate(fact)) {
            this.propogateAssert(fact, engine, mem);
        }
    }

    public boolean evaluate(Fact factInstance) {
        return Evaluate.evaluate(this.operator, factInstance.getSlotValue(this.slot.getId()), this.slot.getValue());
    }

    public String toString() {
        return "slot(" + this.slot.getId() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + this.slot.getValue().toString() + " - useCount=" + this.useCount;
    }

    public CompositeIndex getHashIndex() {
        if (this.compIndex == null) {
            this.compIndex = new CompositeIndex(this.slot.getName(), this.operator, this.slot.getValue());
        }
        return this.compIndex;
    }

    public String hashString() {
        if (this.hashstring == null) {
            this.hashstring = String.valueOf(this.slot.getId()) + ":" + this.operator + ":" + String.valueOf(this.slot.getValue());
        }
        return this.hashstring;
    }

    public String toPPString() {
        return "<node-" + this.nodeID + "> slot(" + this.slot.getName() + ") " + ConversionUtils.getPPOperator(this.operator) + " " + ConversionUtils.formatSlot(this.slot.getValue()) + " - useCount=" + this.useCount;
    }

    public QueryBaseAlpha clone(Rete engine, Defquery query) {
        QueryAlphaNode clone = new QueryAlphaNode(engine.nextNodeId());
        clone.operator = this.operator;
        clone.slot = (Slot)this.slot.clone();
        clone.successorNodes = new BaseNode[this.successorNodes.length];
        int i = 0;
        while (i < this.successorNodes.length) {
            if (this.successorNodes[i] instanceof QueryBaseAlpha) {
                clone.successorNodes[i] = ((QueryBaseAlpha)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryBaseJoin) {
                clone.successorNodes[i] = ((QueryBaseJoin)this.successorNodes[i]).clone(engine, query);
            } else if (this.successorNodes[i] instanceof QueryResultNode) {
                clone.successorNodes[i] = ((QueryResultNode)this.successorNodes[i]).clone(engine, query);
            }
            ++i;
        }
        return clone;
    }
}

