/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.measures;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.measures.AggregateMeasure;

public class SumMeasure
implements AggregateMeasure {
    public static final String SUM = "sum";

    public BigDecimal calculate(Rete engine, Cube cube, Object[] data, CubeBinding binding) {
        if (data != null) {
            BigDecimal sum = new BigDecimal(0);
            int idx = 0;
            while (idx < data.length) {
                Index facts = (Index)data[idx];
                Object value = facts.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
                if (value instanceof Number) {
                    Number n = (Number)value;
                    sum = sum.add(new BigDecimal(n.doubleValue()));
                } else if (value instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)value;
                    sum = sum.add(bd);
                } else if (value instanceof BigInteger) {
                    BigInteger bi = (BigInteger)value;
                    sum = sum.add(new BigDecimal(bi.longValue()));
                }
                ++idx;
            }
            return sum;
        }
        return new BigDecimal(0);
    }

    public String getMeasureName() {
        return SUM;
    }

    public String getDescription() {
        return "Sum will add up the values and return a BigDecimal result";
    }
}

