/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.measures;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.measures.AggregateMeasure;

public class StandardDeviationMeasure
implements AggregateMeasure {
    public static final String STANDARD_DEVIATION = "stdev";

    public BigDecimal calculate(Rete engine, Cube cube, Object[] data, CubeBinding binding) {
        if (data != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            int idx = 0;
            while (idx < data.length) {
                Index facts = (Index)data[idx];
                Object value = facts.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
                values.add(value);
                ++idx;
            }
            return this.calculate(engine, cube, values);
        }
        return new BigDecimal(0);
    }

    protected BigDecimal calculate(Rete engine, Cube cube, List data) {
        BigDecimal sum = new BigDecimal(0);
        int idx = 0;
        while (idx < data.size()) {
            Object value = data.get(idx);
            if (value instanceof Number) {
                Number n = (Number)value;
                sum = sum.add(new BigDecimal(n.doubleValue()));
            } else if (value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)value;
                sum = sum.add(bd);
            } else if (value instanceof BigInteger) {
                BigInteger bi = (BigInteger)value;
                sum = sum.add(new BigDecimal(bi.longValue()));
            }
            ++idx;
        }
        BigDecimal average = sum.divide(new BigDecimal(data.size()), 30, 1);
        sum = new BigDecimal(0);
        int idx2 = 0;
        while (idx2 < data.size()) {
            BigDecimal dev;
            Object value = data.get(idx2);
            if (value instanceof Number) {
                Number n = (Number)value;
                BigDecimal dev2 = new BigDecimal(n.doubleValue()).subtract(average);
                sum = sum.add(dev2.pow(2));
            } else if (value instanceof BigDecimal) {
                dev = ((BigDecimal)value).subtract(average);
                sum = sum.add(dev.pow(2));
            } else if (value instanceof BigInteger) {
                dev = new BigDecimal(value.toString()).subtract(average);
                sum = sum.add(dev.pow(2));
            }
            ++idx2;
        }
        BigDecimal dev = sum.divide(new BigDecimal(data.size()), 20, 1);
        return new BigDecimal(Math.sqrt(dev.doubleValue()));
    }

    public String getDescription() {
        return "Returns the standard deviation for a given dataset.";
    }

    public String getMeasureName() {
        return STANDARD_DEVIATION;
    }
}

