/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.measures;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.measures.AggregateMeasure;

public class SeventyPercentMeasure
implements AggregateMeasure {
    public static final String SEVENTY_PERCENT = "70-percentile";

    protected BigDecimal calculate(Rete engine, Cube cube, List data) {
        if (data != null) {
            Collections.sort(data);
            Object value = data.get((int)((double)data.size() * 0.7));
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }
        return new BigDecimal(0);
    }

    public BigDecimal calculate(Rete engine, Cube cube, Object[] data, CubeBinding binding) {
        if (data != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            int idx = 0;
            while (idx < data.length) {
                Index facts = (Index)data[idx];
                Object value = facts.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
                values.add(value);
                ++idx;
            }
            return this.calculate(engine, cube, values);
        }
        return new BigDecimal(0);
    }

    public String getDescription() {
        return "70th percentile of a given set of numbers";
    }

    public String getMeasureName() {
        return SEVENTY_PERCENT;
    }
}

