/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.measures;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.measures.AggregateMeasure;

public class MinMeasure
implements AggregateMeasure {
    public static final String MIN = "min";

    public BigDecimal calculate(Rete engine, Cube cube, Object[] data, CubeBinding binding) {
        if (data != null && data.length > 0) {
            Index first = (Index)data[0];
            Object fvalue = first.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
            BigDecimal min = new BigDecimal(fvalue.toString());
            int idx = 1;
            while (idx < data.length) {
                Index facts = (Index)data[idx];
                Object value = facts.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
                if (value instanceof Number) {
                    Number n = (Number)value;
                    min = min.min(new BigDecimal(n.doubleValue()));
                } else if (value instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)value;
                    min = min.min(bd);
                } else if (value instanceof BigInteger) {
                    BigInteger bi = (BigInteger)value;
                    min = min.min(new BigDecimal(bi.longValue()));
                }
                ++idx;
            }
            return min;
        }
        return new BigDecimal(0);
    }

    public String getDescription() {
        return "Returns the min value of a given dataset from a multi-dimensional cube query.";
    }

    public String getMeasureName() {
        return MIN;
    }
}

