/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.measures;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.measures.AggregateMeasure;

public class MedianMeasure
implements AggregateMeasure {
    public static final String MEDIAN = "median";

    protected BigDecimal calculate(Rete engine, Cube cube, List data) {
        if (data != null) {
            Collections.sort(data);
            int size = data.size();
            if (size % 2 == 1) {
                int div = size / 2;
                Object value = data.get(div);
                if (value instanceof BigDecimal) {
                    return (BigDecimal)value;
                }
                if (value instanceof Number) {
                    return new BigDecimal(((Number)value).doubleValue());
                }
                return new BigDecimal(value.toString());
            }
            int div = size / 2;
            Object val1 = data.get(div);
            Object val2 = data.get(div - 1);
            BigDecimal total = this.addValues(val1, val2);
            return total.divide(new BigDecimal(2), 30, 1);
        }
        return new BigDecimal(0);
    }

    public BigDecimal calculate(Rete engine, Cube cube, Object[] data, CubeBinding binding) {
        if (data != null) {
            ArrayList<Object> values = new ArrayList<Object>();
            int idx = 0;
            while (idx < data.length) {
                Index facts = (Index)data[idx];
                Object value = facts.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
                values.add(value);
                ++idx;
            }
            return this.calculate(engine, cube, values);
        }
        return new BigDecimal(0);
    }

    protected BigDecimal addValues(Object val1, Object val2) {
        BigDecimal bd1 = null;
        BigDecimal bd2 = null;
        bd1 = val1 instanceof BigDecimal ? (BigDecimal)val1 : new BigDecimal(val1.toString());
        bd2 = val2 instanceof BigDecimal ? (BigDecimal)val2 : new BigDecimal(val2.toString());
        return bd1.add(bd2);
    }

    public String getDescription() {
        return "Median is the value in the middle of a dataset.";
    }

    public String getMeasureName() {
        return MEDIAN;
    }
}

