/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.measures;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jamocha.rete.Cube;
import org.jamocha.rete.CubeBinding;
import org.jamocha.rete.Index;
import org.jamocha.rete.Rete;
import org.jamocha.rete.measures.AggregateMeasure;

public class MaxMeasure
implements AggregateMeasure {
    public static final String MAX = "max";

    public BigDecimal calculate(Rete engine, Cube cube, Object[] data, CubeBinding binding) {
        if (data != null && data.length > 0) {
            Index first = (Index)data[0];
            Object fvalue = first.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
            BigDecimal max = new BigDecimal(fvalue.toString());
            int idx = 0;
            while (idx < data.length) {
                Index facts = (Index)data[idx];
                Object value = facts.getFacts()[binding.getLeftRow()].getSlotValue(binding.getLeftIndex());
                if (value instanceof Number) {
                    Number n = (Number)value;
                    max = max.max(new BigDecimal(n.doubleValue()));
                } else if (value instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)value;
                    max = max.max(bd);
                } else if (value instanceof BigInteger) {
                    BigInteger bi = (BigInteger)value;
                    max = max.max(new BigDecimal(bi.longValue()));
                }
                ++idx;
            }
            return max;
        }
        return new BigDecimal(0);
    }

    public String getDescription() {
        return "Returns the max value of a given dataset from a multi-dimensional cube query.";
    }

    public String getMeasureName() {
        return MAX;
    }
}

