/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.time;

import java.util.Date;
import java.util.GregorianCalendar;
import org.jamocha.rete.BoundParam;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.FunctionParam2;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.time.AbstractTimeFunction;

public class WithinDaysFunction
extends AbstractTimeFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String WITHIN_DAYS = "within-days";
    protected GregorianCalendar calendar1 = new GregorianCalendar();
    protected GregorianCalendar calendar2 = new GregorianCalendar();
    protected GregorianCalendar calendar3 = new GregorianCalendar();

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean eval = false;
        if (params != null && params.length == 3) {
            int interval = params[0].getIntValue();
            Date date1 = null;
            if (params[1] instanceof ValueParam) {
                date1 = this.getDate(params[1].getValue());
            } else if (params[1] instanceof BoundParam) {
                date1 = this.getDate(engine.getBinding(((BoundParam)params[1]).getVariableName()));
            } else if (params[1] instanceof FunctionParam2) {
                date1 = this.getDate(((FunctionParam2)params[1]).getValue(engine, 25));
            }
            Date date2 = null;
            if (params[2] instanceof ValueParam) {
                date2 = this.getDate(params[2].getValue());
            } else if (params[2] instanceof BoundParam) {
                date2 = this.getDate(engine.getBinding(((BoundParam)params[2]).getVariableName()));
            } else if (params[2] instanceof FunctionParam2) {
                date2 = this.getDate(((FunctionParam2)params[2]).getValue(engine, 25));
            }
            if (date1 != null && date2 != null) {
                this.calendar1.setTime(date1);
                this.calendar2.setTime(date2);
                this.calendar3.setTime(date1);
                this.calendar3.add(5, interval);
                if (this.calendar2.compareTo(this.calendar1) >= 0 && this.calendar2.compareTo(this.calendar3) <= 0) {
                    eval = true;
                }
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(eval));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return WITHIN_DAYS;
    }

    public Class[] getParameter() {
        return new Class[]{Date.class, Date.class};
    }

    public int getReturnType() {
        return 20;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(within-days <date> <date>)";
    }
}

