/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.time;

import java.util.Date;
import java.util.GregorianCalendar;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.functions.time.AbstractTimeFunction;

public class AddMinutesFunction
extends AbstractTimeFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String ADD_MINUTES = "add-minutes";
    protected GregorianCalendar calendar = new GregorianCalendar();

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        Date date = null;
        if (params != null && params.length == 2) {
            int minutes = params[0].getIntValue();
            date = this.getDate(params[1].getValue());
            if (date != null) {
                this.calendar.setTime(date);
                this.calendar.add(12, minutes);
                date = this.calendar.getTime();
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(25, date);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return ADD_MINUTES;
    }

    public Class[] getParameter() {
        return new Class[]{Date.class};
    }

    public int getReturnType() {
        return 25;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(add-minutes <minutes> <date>)";
    }
}

