/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.temporal;

import java.io.Serializable;
import java.util.Collection;
import org.jamocha.rete.Rete;
import org.jamocha.rete.Template;
import org.jamocha.rule.AbstractCondition;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Defrule;
import org.jamocha.rule.TemporalCondition;

public class TemporalCalculation
implements Serializable {
    private static final long serialVersionUID = 1L;

    public boolean calcuateDistance(Rete engine, Collection rules) {
        for (Defrule rule : rules) {
            Template template;
            AbstractCondition condition;
            Condition[] conditions = rule.getConditions();
            int distance = -1;
            int idx = 0;
            while (idx < conditions.length) {
                condition = (AbstractCondition)conditions[idx];
                template = condition.getTemplate();
                if (condition instanceof TemporalCondition) {
                    TemporalCondition temporal = (TemporalCondition)condition;
                    if (distance == -1) {
                        distance = 0;
                    }
                    distance = temporal.getRelativeTime() > 0 ? (distance += temporal.getRelativeTime() * 1000) : (distance += temporal.getIntervalTime() * 1000);
                    if (distance > 0 && distance > template.getTemporalDistance()) {
                        template.setTemporalDistance(distance);
                    }
                }
                ++idx;
            }
            if (distance != -1) continue;
            idx = 0;
            while (idx < conditions.length) {
                condition = (AbstractCondition)conditions[idx];
                template = condition.getTemplate();
                template.setNonTemporalRules(true);
                ++idx;
            }
        }
        return true;
    }
}

