/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.string;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class SubStringFunction
implements Function,
Serializable {
    public static final String SUBSTRING = "sub-string";

    public int getReturnType() {
        return 11;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        String sub = null;
        if (params != null && params.length == 3) {
            int begin = params[0].getIntValue();
            int end = params[1].getIntValue();
            String txt = params[2].getStringValue();
            sub = txt.substring(begin, end);
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(11, sub);
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return SUBSTRING;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class, ValueParam.class, ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(sub-string [begin] [end] [string])";
    }
}

