/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.string;

import java.io.Serializable;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;

public class StringLengthFunction
implements Function,
Serializable {
    public static final String STRING_LENGTH = "str-length";

    public int getReturnType() {
        return 14;
    }

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        int len = 0;
        if (params != null && params.length == 1) {
            String txt = params[0].getStringValue();
            len = txt.length();
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(14, new Integer(len));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return STRING_LENGTH;
    }

    public Class[] getParameter() {
        return new Class[]{ValueParam.class};
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(str-length [string])";
    }
}

