/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.messaging;

import java.io.Serializable;
import org.jamocha.messaging.MessageClient;
import org.jamocha.rete.DefaultReturnValue;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.Function;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;

public class SendMessageFunction
implements Function {
    private static final long serialVersionUID = 1L;
    public static final String SEND_MSG = "send-msg";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        boolean sent = false;
        if (params != null && params.length == 2) {
            String client = params[0].getStringValue();
            String message = params[1].getStringValue();
            MessageClient msgClient = (MessageClient)engine.getDefglobalValue(client);
            if (msgClient != null) {
                msgClient.publish((Serializable)((Object)message));
                sent = true;
            }
        }
        DefaultReturnVector ret = new DefaultReturnVector();
        DefaultReturnValue rv = new DefaultReturnValue(20, new Boolean(sent));
        ret.addReturnValue(rv);
        return ret;
    }

    public String getName() {
        return SEND_MSG;
    }

    public Class[] getParameter() {
        return new Class[]{String.class, String.class};
    }

    public int getReturnType() {
        return 20;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(send-msg <*client instance name*> <message>)";
    }
}

