/*
 * Decompiled with CFR 0.152.
 */
package org.jamocha.rete.functions.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jamocha.rete.BaseAlpha;
import org.jamocha.rete.BaseJoin;
import org.jamocha.rete.Constants;
import org.jamocha.rete.DefaultReturnVector;
import org.jamocha.rete.DefaultWM;
import org.jamocha.rete.ExistJoin;
import org.jamocha.rete.Fact;
import org.jamocha.rete.Function;
import org.jamocha.rete.HashedAlphaMemoryImpl;
import org.jamocha.rete.HashedEqBNode;
import org.jamocha.rete.HashedEqNJoin;
import org.jamocha.rete.HashedNeqAlphaMemory;
import org.jamocha.rete.HashedNotEqBNode;
import org.jamocha.rete.HashedNotEqNJoin;
import org.jamocha.rete.Index;
import org.jamocha.rete.LIANode;
import org.jamocha.rete.NotJoin;
import org.jamocha.rete.Parameter;
import org.jamocha.rete.Rete;
import org.jamocha.rete.ReturnVector;
import org.jamocha.rete.ValueParam;
import org.jamocha.rete.functions.BaseMatchFunction;
import org.jamocha.rule.Condition;
import org.jamocha.rule.Defrule;

public class RuleMatchesFunction
extends BaseMatchFunction
implements Function,
Serializable {
    public static final String RULE_MATCHES = "rule-matches";

    public ReturnVector executeFunction(Rete engine, Parameter[] params) {
        if (params != null && params.length > 0) {
            ArrayList<Defrule> rules = new ArrayList<Defrule>();
            int idx = 0;
            while (idx < params.length) {
                if (params[idx] instanceof ValueParam) {
                    String name = params[idx].getStringValue();
                    Defrule r = (Defrule)engine.getCurrentFocus().findRule(name);
                    if (r != null && !rules.contains(r)) {
                        rules.add(r);
                    }
                }
                ++idx;
            }
            DefaultWM wm = (DefaultWM)engine.getWorkingMemory();
            int idx2 = 0;
            while (idx2 < rules.size()) {
                this.printRuleMemories(engine, (Defrule)rules.get(idx2), wm);
                ++idx2;
            }
        }
        return new DefaultReturnVector();
    }

    protected void printRuleMemories(Rete engine, Defrule rule, DefaultWM wm) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(rule.getName()) + Constants.LINEBREAK);
        Condition[] conditions = rule.getConditions();
        int idx = 0;
        while (idx < conditions.length) {
            Condition c = conditions[idx];
            List nodes = c.getNodes();
            for (BaseAlpha n : nodes) {
                if (n instanceof LIANode) continue;
                Map rmem = (Map)wm.getBetaRightMemory(n);
                buf.append(String.valueOf(n.toPPString()) + " - right memories:" + rmem.size() + Constants.LINEBREAK);
                for (Fact f2 : rmem.keySet()) {
                    buf.append("\t" + f2.toFactString() + Constants.LINEBREAK);
                }
            }
            ++idx;
        }
        List betaNodes = rule.getJoins();
        for (BaseJoin betaNode : betaNodes) {
            Fact f;
            Object[] facts;
            buf.append(String.valueOf(betaNode.toPPString()) + Constants.LINEBREAK);
            Map lmem = (Map)wm.getBetaLeftMemory(betaNode);
            Object rmem = wm.getBetaRightMemory(betaNode);
            if (lmem.size() > 0) {
                buf.append(" - left memories:" + Constants.LINEBREAK);
                for (Index mem : lmem.keySet()) {
                    buf.append("\t" + mem.toPPString() + Constants.LINEBREAK);
                }
            }
            buf.append(" - right memories:" + Constants.LINEBREAK);
            if (betaNode instanceof HashedEqBNode || betaNode instanceof HashedEqNJoin) {
                HashedAlphaMemoryImpl haMem = (HashedAlphaMemoryImpl)rmem;
                facts = haMem.iterateAll();
                int idx2 = 0;
                while (idx2 < facts.length) {
                    f = (Fact)facts[idx2];
                    buf.append("\t" + f.toFactString() + Constants.LINEBREAK);
                    ++idx2;
                }
            } else if (betaNode instanceof HashedNotEqNJoin || betaNode instanceof HashedNotEqBNode) {
                HashedNeqAlphaMemory haneqMem = (HashedNeqAlphaMemory)rmem;
                facts = haneqMem.iterateAll();
                int idx3 = 0;
                while (idx3 < facts.length) {
                    f = (Fact)facts[idx3];
                    buf.append("\t" + f.toFactString() + Constants.LINEBREAK);
                    ++idx3;
                }
            } else if (betaNode instanceof ExistJoin || betaNode instanceof NotJoin) {
                Map rmMem = (Map)rmem;
                for (Fact f2 : rmMem.keySet()) {
                    buf.append("\t" + f2.toFactString() + Constants.LINEBREAK);
                }
            }
            buf.append(Constants.LINEBREAK);
        }
        engine.writeMessage(buf.toString());
    }

    public String getName() {
        return RULE_MATCHES;
    }

    public Class[] getParameter() {
        return new Class[]{String[].class};
    }

    public int getReturnType() {
        return 12;
    }

    public String toPPString(Parameter[] params, int indents) {
        return "(rule-matches <Rule name>)Function description:\n\tPrints out the memories for a rule.";
    }
}

